/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.openstreetmap.josm.gui.help.HelpContentReaderException;
import org.openstreetmap.josm.gui.help.MissingHelpContentException;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WikiReader;

public class HelpContentReader
extends WikiReader {
    public HelpContentReader(String string) {
        super(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchHelpTopicContent(String string, boolean bl) throws HelpContentReaderException {
        if (string == null) {
            throw new MissingHelpContentException(string);
        }
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = Utils.openHttpConnection(uRL);
            httpURLConnection.connect();
            try (BufferedReader object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), StandardCharsets.UTF_8));){
                String string2 = this.prepareHelpContent(object, bl, uRL);
                return string2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new HelpContentReaderException(malformedURLException);
        }
        catch (IOException iOException) {
            HelpContentReaderException helpContentReaderException = new HelpContentReaderException(iOException);
            if (httpURLConnection == null) throw helpContentReaderException;
            try {
                helpContentReaderException.setResponseCode(httpURLConnection.getResponseCode());
                throw helpContentReaderException;
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw helpContentReaderException;
        }
    }

    protected String prepareHelpContent(BufferedReader bufferedReader, boolean bl, URL uRL) throws HelpContentReaderException {
        String string = "";
        try {
            string = this.readFromTrac(bufferedReader, uRL);
        }
        catch (IOException iOException) {
            throw new HelpContentReaderException(iOException);
        }
        if (bl && string.isEmpty()) {
            throw new MissingHelpContentException(string);
        }
        return string;
    }
}

