/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationNodeMap;
import org.openstreetmap.josm.tools.AlphanumComparator;

public class RelationSorter {
    private static final Collection<AdditionalSorter> additionalSorters = new ArrayList<AdditionalSorter>();

    public List<RelationMember> sortMembers(List<RelationMember> list) {
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        ArrayList<RelationMember> arrayList2 = new ArrayList<RelationMember>(list.size());
        LinkedHashMap<AdditionalSorter, LinkedList<RelationMember>> linkedHashMap = new LinkedHashMap<AdditionalSorter, LinkedList<RelationMember>>();
        for (RelationMember object : list) {
            boolean bl = false;
            for (AdditionalSorter additionalSorter : additionalSorters) {
                if (!additionalSorter.acceptsMember(object)) continue;
                LinkedList<RelationMember> linkedList = (LinkedList<RelationMember>)linkedHashMap.get(additionalSorter);
                if (linkedList == null) {
                    linkedList = new LinkedList<RelationMember>();
                    linkedHashMap.put(additionalSorter, linkedList);
                }
                linkedList.add(object);
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList2.add(object);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            arrayList.addAll(((AdditionalSorter)entry.getKey()).sortMembers((List)entry.getValue()));
        }
        arrayList.addAll(RelationSorter.sortMembersByConnectivity(arrayList2));
        return arrayList;
    }

    public static List<RelationMember> sortMembersByConnectivity(List<RelationMember> list) {
        Integer n;
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        RelationNodeMap relationNodeMap = new RelationNodeMap(list);
        ArrayList arrayList2 = new ArrayList();
        while ((n = relationNodeMap.pop()) != null) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.add(n);
            arrayList2.add(linkedList);
            Object object = n;
            while ((object = relationNodeMap.popAdjacent((Integer)object)) != null) {
                linkedList.addLast(object);
            }
            object = n;
            while ((object = relationNodeMap.popAdjacent((Integer)object)) != null) {
                linkedList.addFirst(object);
            }
        }
        for (LinkedList serializable : arrayList2) {
            for (Integer n2 : serializable) {
                arrayList.add(list.get(n2));
            }
        }
        for (Integer n3 : relationNodeMap.getNotSortableMembers()) {
            arrayList.add(list.get(n3));
        }
        return arrayList;
    }

    static {
        additionalSorters.add(new AssociatedStreetRoleStreetSorter());
        additionalSorters.add(new AssociatedStreetRoleAddressHouseSorter());
    }

    private static class AssociatedStreetRoleAddressHouseSorter
    implements AdditionalSorter {
        private AssociatedStreetRoleAddressHouseSorter() {
        }

        @Override
        public boolean acceptsMember(RelationMember relationMember) {
            return "address".equals(relationMember.getRole()) || "house".equals(relationMember.getRole());
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            Collections.sort(list, new Comparator<RelationMember>(){

                @Override
                public int compare(RelationMember relationMember, RelationMember relationMember2) {
                    int n = AlphanumComparator.getInstance().compare(relationMember.getMember().get("addr:housenumber"), relationMember2.getMember().get("addr:housenumber"));
                    if (n != 0) {
                        return n;
                    }
                    String string = relationMember.getMember().getDisplayName(DefaultNameFormatter.getInstance());
                    String string2 = relationMember2.getMember().getDisplayName(DefaultNameFormatter.getInstance());
                    return AlphanumComparator.getInstance().compare(string, string2);
                }
            });
            return list;
        }
    }

    private static class AssociatedStreetRoleStreetSorter
    implements AdditionalSorter {
        private AssociatedStreetRoleStreetSorter() {
        }

        @Override
        public boolean acceptsMember(RelationMember relationMember) {
            return "street".equals(relationMember.getRole());
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            return RelationSorter.sortMembersByConnectivity(list);
        }
    }

    private static interface AdditionalSorter {
        public boolean acceptsMember(RelationMember var1);

        public List<RelationMember> sortMembers(List<RelationMember> var1);
    }
}

