/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.AddNoteAction;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class NoteDialog
extends ToggleDialog
implements MapView.LayerChangeListener {
    public static final int ICON_SMALL_SIZE = 16;
    public static final int ICON_LARGE_SIZE = 24;
    public static final ImageIcon ICON_OPEN = ImageProvider.get("dialogs/notes", "note_open.png");
    public static final ImageIcon ICON_OPEN_SMALL = new ImageIcon(ICON_OPEN.getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon ICON_CLOSED = ImageProvider.get("dialogs/notes", "note_closed.png");
    public static final ImageIcon ICON_CLOSED_SMALL = new ImageIcon(ICON_CLOSED.getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon ICON_NEW = ImageProvider.get("dialogs/notes", "note_new.png");
    public static final ImageIcon ICON_NEW_SMALL = new ImageIcon(ICON_NEW.getImage().getScaledInstance(16, 16, 4));
    public static final ImageIcon ICON_COMMENT = ImageProvider.get("dialogs/notes", "note_comment.png");
    private NoteTableModel model;
    private JList<Note> displayList;
    private final AddCommentAction addCommentAction;
    private final CloseAction closeAction;
    private final NewAction newAction;
    private final ReopenAction reopenAction;
    private NoteData noteData;

    public NoteDialog() {
        super("Notes", "notes/note_open.png", "List of notes", null, 150);
        Main.debug("constructed note dialog");
        this.addCommentAction = new AddCommentAction();
        this.closeAction = new CloseAction();
        this.newAction = new NewAction();
        this.reopenAction = new ReopenAction();
        this.buildDialog();
    }

    @Override
    public void showDialog() {
        super.showDialog();
    }

    private void buildDialog() {
        this.model = new NoteTableModel();
        this.displayList = new JList<Note>(this.model);
        this.displayList.setCellRenderer(new NoteRenderer());
        this.displayList.setSelectionMode(0);
        this.displayList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (NoteDialog.this.noteData != null) {
                    NoteDialog.this.noteData.setSelectedNote((Note)NoteDialog.this.displayList.getSelectedValue());
                }
                NoteDialog.this.updateButtonStates();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.displayList), "Center");
        this.createLayout(jPanel, false, Arrays.asList(new SideButton((Action)this.newAction, false), new SideButton((Action)this.addCommentAction, false), new SideButton((Action)this.closeAction, false), new SideButton((Action)this.reopenAction, false)));
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.noteData == null || this.noteData.getSelectedNote() == null) {
            this.closeAction.setEnabled(false);
            this.addCommentAction.setEnabled(false);
            this.reopenAction.setEnabled(false);
        } else if (this.noteData.getSelectedNote().getState() == Note.State.open) {
            this.closeAction.setEnabled(true);
            this.addCommentAction.setEnabled(true);
            this.reopenAction.setEnabled(false);
        } else {
            this.closeAction.setEnabled(false);
            this.addCommentAction.setEnabled(false);
            this.reopenAction.setEnabled(true);
        }
    }

    @Override
    public void showNotify() {
        MapView.addLayerChangeListener(this);
    }

    @Override
    public void hideNotify() {
        MapView.removeLayerChangeListener(this);
    }

    @Override
    public void activeLayerChange(Layer layer, Layer layer2) {
    }

    @Override
    public void layerAdded(Layer layer) {
        Main.debug("layer added: " + layer);
        if (layer instanceof NoteLayer) {
            Main.debug("note layer added");
            this.noteData = ((NoteLayer)layer).getNoteData();
            this.model.setData(this.noteData.getNotes());
        }
    }

    @Override
    public void layerRemoved(Layer layer) {
        if (layer instanceof NoteLayer) {
            Main.debug("note layer removed. Clearing everything");
            this.noteData = null;
            this.model.clearData();
            if (Main.map.mapMode instanceof AddNoteAction) {
                Main.map.selectMapMode(Main.map.mapModeSelect);
            }
        }
    }

    public void setNoteList(List<Note> list) {
        this.model.setData(list);
        this.updateButtonStates();
        this.repaint();
    }

    public void selectionChanged() {
        if (this.noteData == null || this.noteData.getSelectedNote() == null) {
            this.displayList.clearSelection();
        } else {
            this.displayList.setSelectedValue(this.noteData.getSelectedNote(), true);
        }
        this.updateButtonStates();
    }

    class ReopenAction
    extends AbstractAction {
        public ReopenAction() {
            this.putValue("ShortDescription", I18n.tr("Reopen note", new Object[0]));
            this.putValue("Name", I18n.tr("Reopen", new Object[0]));
            this.putValue("SmallIcon", ICON_OPEN);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = JOptionPane.showInputDialog(Main.map, I18n.tr("Reopen note with message:", new Object[0]), I18n.tr("Reopen note", new Object[0]), 3, ICON_OPEN, null, null);
            if (object == null) {
                return;
            }
            Note note = (Note)NoteDialog.this.displayList.getSelectedValue();
            NoteDialog.this.noteData.reOpenNote(note, object.toString());
        }
    }

    class NewAction
    extends AbstractAction {
        public NewAction() {
            this.putValue("ShortDescription", I18n.tr("Create a new note", new Object[0]));
            this.putValue("Name", I18n.tr("Create", new Object[0]));
            this.putValue("SmallIcon", ICON_NEW);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NoteDialog.this.noteData == null) {
                Main.map.mapView.addLayer(new NoteLayer());
            }
            Main.map.selectMapMode(new AddNoteAction(Main.map, NoteDialog.this.noteData));
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            this.putValue("ShortDescription", I18n.tr("Close note", new Object[0]));
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            this.putValue("SmallIcon", ICON_CLOSED);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = JOptionPane.showInputDialog(Main.map, I18n.tr("Close note with message:", new Object[0]), I18n.tr("Close Note", new Object[0]), 3, ICON_CLOSED, null, null);
            if (object == null) {
                return;
            }
            Note note = (Note)NoteDialog.this.displayList.getSelectedValue();
            NoteDialog.this.noteData.closeNote(note, object.toString());
        }
    }

    class AddCommentAction
    extends AbstractAction {
        public AddCommentAction() {
            this.putValue("ShortDescription", I18n.tr("Add comment", new Object[0]));
            this.putValue("Name", I18n.tr("Comment", new Object[0]));
            this.putValue("SmallIcon", ICON_COMMENT);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Note note = (Note)NoteDialog.this.displayList.getSelectedValue();
            if (note == null) {
                JOptionPane.showMessageDialog(Main.map, "You must select a note first", "No note selected", 0);
                return;
            }
            Object object = JOptionPane.showInputDialog(Main.map, I18n.tr("Add comment to note:", new Object[0]), I18n.tr("Add comment", new Object[0]), 3, ICON_COMMENT, null, null);
            if (object == null) {
                return;
            }
            NoteDialog.this.noteData.addCommentToNote(note, object.toString());
        }
    }

    class NoteTableModel
    extends AbstractListModel<Note> {
        private List<Note> data = new ArrayList<Note>();

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Note getElementAt(int n) {
            return this.data.get(n);
        }

        public void setData(List<Note> list) {
            this.data.clear();
            this.data.addAll(list);
            this.fireContentsChanged(this, 0, list.size());
        }

        public void clearData() {
            NoteDialog.this.displayList.clearSelection();
            this.data.clear();
            this.fireIntervalRemoved(this, 0, this.getSize());
        }
    }

    private class NoteRenderer
    implements ListCellRenderer<Note> {
        private DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer();
        private final SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy kk:mm");

        private NoteRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Note> jList, Note note, int n, boolean bl, boolean bl2) {
            Component component = this.defaultListCellRenderer.getListCellRendererComponent(jList, note, n, bl, bl2);
            if (note != null && component instanceof JLabel) {
                String string = note.getFirstComment().getText();
                String string2 = note.getFirstComment().getUser().getName();
                if (string2 == null || string2.isEmpty()) {
                    string2 = "<Anonymous>";
                }
                String string3 = string2 + " @ " + this.sdf.format(note.getCreatedAt());
                JLabel jLabel = (JLabel)component;
                jLabel.setText(string);
                ImageIcon imageIcon = note.getId() < 0L ? ICON_NEW_SMALL : (note.getState() == Note.State.closed ? ICON_CLOSED_SMALL : ICON_OPEN_SMALL);
                jLabel.setIcon(imageIcon);
                jLabel.setToolTipText(string3);
            }
            return component;
        }
    }
}

