/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.JumpToMarkerActions;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.MultikeyActionsHandler;
import org.openstreetmap.josm.tools.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.Shortcut;

public class LayerListDialog
extends ToggleDialog {
    private static LayerListDialog instance;
    private LayerListModel model;
    private LayerList layerList;
    private SideButton opacityButton;
    ActivateLayerAction activateLayerAction;
    ShowHideLayerAction showHideLayerAction;
    private final Shortcut[] visibilityToggleShortcuts = new Shortcut[10];
    private final ToggleLayerIndexVisibility[] visibilityToggleActions = new ToggleLayerIndexVisibility[10];

    public static void createInstance(MapFrame mapFrame) {
        if (instance != null) {
            throw new IllegalStateException("Dialog was already created");
        }
        instance = new LayerListDialog(mapFrame);
    }

    public static LayerListDialog getInstance() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("Dialog not created yet. Invoke createInstance() first");
        }
        return instance;
    }

    private final void createVisibilityToggleShortcuts() {
        int[] nArray = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
        for (int i = 0; i < 10; ++i) {
            this.visibilityToggleShortcuts[i] = Shortcut.registerShortcut("subwindow:layers:toggleLayer" + (i + 1), I18n.tr("Toggle visibility of layer: {0}", i + 1), nArray[i], 5004);
            this.visibilityToggleActions[i] = new ToggleLayerIndexVisibility(i);
            Main.registerActionShortcut(this.visibilityToggleActions[i], this.visibilityToggleShortcuts[i]);
        }
    }

    protected LayerListDialog(MapFrame mapFrame) {
        super(I18n.tr("Layers", new Object[0]), "layerlist", I18n.tr("Open a list of all loaded layers.", new Object[0]), Shortcut.registerShortcut("subwindow:layers", I18n.tr("Toggle: {0}", I18n.tr("Layers", new Object[0])), 76, 5007), 100, true);
        Serializable serializable2;
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.setSelectionMode(2);
        this.model = new LayerListModel(defaultListSelectionModel);
        this.layerList = new LayerList(this.model);
        this.layerList.setSelectionModel(defaultListSelectionModel);
        this.layerList.addMouseListener(new PopupMenuHandler());
        this.layerList.setBackground(UIManager.getColor("Button.background"));
        this.layerList.putClientProperty("terminateEditOnFocusLost", true);
        this.layerList.putClientProperty("JTable.autoStartsEdit", false);
        this.layerList.setSelectionMode(2);
        this.layerList.setTableHeader(null);
        this.layerList.setShowGrid(false);
        this.layerList.setIntercellSpacing(new Dimension(0, 0));
        this.layerList.getColumnModel().getColumn(0).setCellRenderer(new ActiveLayerCellRenderer());
        this.layerList.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new ActiveLayerCheckBox()));
        this.layerList.getColumnModel().getColumn(0).setMaxWidth(12);
        this.layerList.getColumnModel().getColumn(0).setPreferredWidth(12);
        this.layerList.getColumnModel().getColumn(0).setResizable(false);
        this.layerList.getColumnModel().getColumn(1).setCellRenderer(new LayerVisibleCellRenderer());
        this.layerList.getColumnModel().getColumn(1).setCellEditor(new LayerVisibleCellEditor(new LayerVisibleCheckBox()));
        this.layerList.getColumnModel().getColumn(1).setMaxWidth(16);
        this.layerList.getColumnModel().getColumn(1).setPreferredWidth(16);
        this.layerList.getColumnModel().getColumn(1).setResizable(false);
        this.layerList.getColumnModel().getColumn(2).setCellRenderer(new LayerNameCellRenderer());
        this.layerList.getColumnModel().getColumn(2).setCellEditor(new LayerNameCellEditor(new DisableShortcutsOnFocusGainedTextField()));
        for (Serializable serializable2 : new KeyStroke[]{KeyStroke.getKeyStroke(67, GuiHelper.getMenuShortcutKeyMaskEx()), KeyStroke.getKeyStroke(86, GuiHelper.getMenuShortcutKeyMaskEx()), KeyStroke.getKeyStroke(40, 64), KeyStroke.getKeyStroke(38, 64), KeyStroke.getKeyStroke(37, 64), KeyStroke.getKeyStroke(39, 64), KeyStroke.getKeyStroke(40, 128), KeyStroke.getKeyStroke(38, 128), KeyStroke.getKeyStroke(37, 128), KeyStroke.getKeyStroke(39, 128), KeyStroke.getKeyStroke(33, 0), KeyStroke.getKeyStroke(34, 0), KeyStroke.getKeyStroke(9, 0), KeyStroke.getKeyStroke(119, 0)}) {
            this.layerList.getInputMap(1).put((KeyStroke)serializable2, new Object());
        }
        MapView mapView = mapFrame.mapView;
        this.model.populate();
        this.model.setSelectedLayer(mapView.getActiveLayer());
        this.model.addLayerListModelListener(new LayerListModelListener(){

            @Override
            public void makeVisible(int n, Layer layer) {
                LayerListDialog.this.layerList.scrollToVisible(n, 0);
                LayerListDialog.this.layerList.repaint();
            }

            @Override
            public void refresh() {
                LayerListDialog.this.layerList.repaint();
            }
        });
        MoveUpAction moveUpAction = new MoveUpAction();
        this.adaptTo((IEnabledStateUpdating)moveUpAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveUpAction, defaultListSelectionModel);
        MoveDownAction moveDownAction = new MoveDownAction();
        this.adaptTo((IEnabledStateUpdating)moveDownAction, this.model);
        this.adaptTo((IEnabledStateUpdating)moveDownAction, defaultListSelectionModel);
        this.activateLayerAction = new ActivateLayerAction();
        this.activateLayerAction.updateEnabledState();
        MultikeyActionsHandler.getInstance().addAction(this.activateLayerAction);
        this.adaptTo((IEnabledStateUpdating)this.activateLayerAction, defaultListSelectionModel);
        JumpToMarkerActions.initialize();
        this.showHideLayerAction = new ShowHideLayerAction();
        MultikeyActionsHandler.getInstance().addAction(this.showHideLayerAction);
        this.adaptTo((IEnabledStateUpdating)this.showHideLayerAction, defaultListSelectionModel);
        serializable2 = new LayerOpacityAction();
        this.adaptTo((IEnabledStateUpdating)((Object)serializable2), defaultListSelectionModel);
        this.opacityButton = new SideButton((Action)((Object)serializable2), false);
        MergeAction mergeAction = new MergeAction();
        this.adaptTo((IEnabledStateUpdating)mergeAction, this.model);
        this.adaptTo((IEnabledStateUpdating)mergeAction, defaultListSelectionModel);
        DuplicateAction duplicateAction = new DuplicateAction();
        this.adaptTo((IEnabledStateUpdating)duplicateAction, this.model);
        this.adaptTo((IEnabledStateUpdating)duplicateAction, defaultListSelectionModel);
        DeleteLayerAction deleteLayerAction = new DeleteLayerAction();
        this.layerList.getActionMap().put("deleteLayer", deleteLayerAction);
        this.adaptTo((IEnabledStateUpdating)deleteLayerAction, defaultListSelectionModel);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", deleteLayerAction);
        InputMapUtils.addEnterAction(this.layerList, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayerListDialog.this.activateLayerAction.actionPerformed(null);
                LayerListDialog.this.layerList.requestFocus();
            }
        });
        InputMapUtils.addSpacebarAction(this.layerList, this.showHideLayerAction);
        this.createLayout(this.layerList, true, Arrays.asList(new SideButton((Action)moveUpAction, false), new SideButton((Action)moveDownAction, false), new SideButton((Action)this.activateLayerAction, false), new SideButton((Action)this.showHideLayerAction, false), this.opacityButton, new SideButton((Action)mergeAction, false), new SideButton((Action)duplicateAction, false), new SideButton((Action)deleteLayerAction, false)));
        this.createVisibilityToggleShortcuts();
    }

    @Override
    public void showNotify() {
        MapView.addLayerChangeListener(this.activateLayerAction);
        MapView.addLayerChangeListener(this.model);
        this.model.populate();
    }

    @Override
    public void hideNotify() {
        MapView.removeLayerChangeListener(this.model);
        MapView.removeLayerChangeListener(this.activateLayerAction);
    }

    public LayerListModel getModel() {
        return this.model;
    }

    protected void adaptTo(final IEnabledStateUpdating iEnabledStateUpdating, ListSelectionModel listSelectionModel) {
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }
        });
    }

    protected void adaptTo(final IEnabledStateUpdating iEnabledStateUpdating, LayerListModel layerListModel) {
        layerListModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                iEnabledStateUpdating.updateEnabledState();
            }
        });
    }

    @Override
    public void destroy() {
        for (int i = 0; i < 10; ++i) {
            Main.unregisterActionShortcut(this.visibilityToggleActions[i], this.visibilityToggleShortcuts[i]);
        }
        MultikeyActionsHandler.getInstance().removeAction(this.activateLayerAction);
        MultikeyActionsHandler.getInstance().removeAction(this.showHideLayerAction);
        JumpToMarkerActions.unregisterActions();
        super.destroy();
        instance = null;
    }

    public ShowHideLayerAction createShowHideLayerAction() {
        return new ShowHideLayerAction();
    }

    public DeleteLayerAction createDeleteLayerAction() {
        return new DeleteLayerAction();
    }

    public ActivateLayerAction createActivateLayerAction(Layer layer) {
        return new ActivateLayerAction(layer);
    }

    public MergeAction createMergeLayerAction(Layer layer) {
        return new MergeAction(layer);
    }

    public static Layer getLayerForIndex(int n) {
        if (!Main.isDisplayingMapView()) {
            return null;
        }
        List<Layer> list = Main.map.mapView.getAllLayersAsList();
        if (n < list.size() && n >= 0) {
            return list.get(n);
        }
        return null;
    }

    public static List<MultikeyShortcutAction.MultikeyInfo> getLayerInfoByClass(Class<?> clazz) {
        ArrayList<MultikeyShortcutAction.MultikeyInfo> arrayList = new ArrayList<MultikeyShortcutAction.MultikeyInfo>();
        if (!Main.isDisplayingMapView()) {
            return arrayList;
        }
        List<Layer> list = Main.map.mapView.getAllLayersAsList();
        int n = 0;
        for (Layer layer : list) {
            if (clazz.isAssignableFrom(layer.getClass())) {
                arrayList.add(new MultikeyShortcutAction.MultikeyInfo(n, layer.getName()));
            }
            ++n;
        }
        return arrayList;
    }

    public static boolean isLayerValid(Layer layer) {
        if (layer == null || !Main.isDisplayingMapView()) {
            return false;
        }
        return Main.map.mapView.getAllLayersAsList().contains(layer);
    }

    public static MultikeyShortcutAction.MultikeyInfo getLayerInfo(Layer layer) {
        if (layer == null || !Main.isDisplayingMapView()) {
            return null;
        }
        int n = Main.map.mapView.getAllLayersAsList().indexOf(layer);
        if (n < 0) {
            return null;
        }
        return new MultikeyShortcutAction.MultikeyInfo(n, layer.getName());
    }

    static class LayerList
    extends JTable {
        public LayerList(TableModel tableModel) {
            super(tableModel);
        }

        public void scrollToVisible(int n, int n2) {
            if (!(this.getParent() instanceof JViewport)) {
                return;
            }
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle rectangle = this.getCellRect(n, n2, true);
            Point point = jViewport.getViewPosition();
            rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
            jViewport.scrollRectToVisible(rectangle);
        }
    }

    public final class LayerListModel
    extends AbstractTableModel
    implements MapView.LayerChangeListener,
    PropertyChangeListener {
        private DefaultListSelectionModel selectionModel;
        private CopyOnWriteArrayList<LayerListModelListener> listeners;

        private LayerListModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
            this.listeners = new CopyOnWriteArrayList();
        }

        public void addLayerListModelListener(LayerListModelListener layerListModelListener) {
            if (layerListModelListener != null) {
                this.listeners.addIfAbsent(layerListModelListener);
            }
        }

        public void removeLayerListModelListener(LayerListModelListener layerListModelListener) {
            this.listeners.remove(layerListModelListener);
        }

        protected void fireMakeVisible(int n, Layer layer) {
            for (LayerListModelListener layerListModelListener : this.listeners) {
                layerListModelListener.makeVisible(n, layer);
            }
        }

        protected void fireRefresh() {
            for (LayerListModelListener layerListModelListener : this.listeners) {
                layerListModelListener.refresh();
            }
        }

        public void populate() {
            for (Layer layer : this.getLayers()) {
                layer.removePropertyChangeListener(this);
                layer.addPropertyChangeListener(this);
            }
            this.fireTableDataChanged();
        }

        public void setSelectedLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            int n = this.getLayers().indexOf(layer);
            if (n >= 0) {
                this.selectionModel.setSelectionInterval(n, n);
            }
            this.ensureSelectedIsVisible();
        }

        public List<Layer> getSelectedLayers() {
            ArrayList<Layer> arrayList = new ArrayList<Layer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(this.getLayers().get(i));
            }
            return arrayList;
        }

        public List<Integer> getSelectedRows() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.getLayers().size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(i);
            }
            return arrayList;
        }

        protected void onRemoveLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.removePropertyChangeListener(this);
            final int n = this.getRowCount();
            final List<Integer> list = this.getSelectedRows();
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    if (list.isEmpty() && n > 0) {
                        LayerListModel.this.selectionModel.setSelectionInterval(n - 1, n - 1);
                    }
                    LayerListModel.this.fireTableDataChanged();
                    LayerListModel.this.fireRefresh();
                    LayerListModel.this.ensureActiveSelected();
                }
            });
        }

        protected void onAddLayer(Layer layer) {
            if (layer == null) {
                return;
            }
            layer.addPropertyChangeListener(this);
            this.fireTableDataChanged();
            int n = this.getLayers().indexOf(layer);
            LayerListDialog.this.layerList.setRowHeight(n, Math.max(16, layer.getIcon().getIconHeight()));
            this.selectionModel.setSelectionInterval(n, n);
            this.ensureSelectedIsVisible();
        }

        public Layer getFirstLayer() {
            if (this.getRowCount() == 0) {
                return null;
            }
            return this.getLayers().get(0);
        }

        public Layer getLayer(int n) {
            if (n < 0 || n >= this.getRowCount()) {
                return null;
            }
            return this.getLayers().get(n);
        }

        public boolean canMoveUp() {
            List<Integer> list = this.getSelectedRows();
            return !list.isEmpty() && list.get(0) > 0;
        }

        public void moveUp() {
            if (!this.canMoveUp()) {
                return;
            }
            List<Integer> list = this.getSelectedRows();
            for (int n : list) {
                Layer layer = this.getLayers().get(n);
                Layer layer2 = this.getLayers().get(n - 1);
                Main.map.mapView.moveLayer(layer2, n);
                Main.map.mapView.moveLayer(layer, n - 1);
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (int n : list) {
                this.selectionModel.addSelectionInterval(n - 1, n - 1);
            }
            this.ensureSelectedIsVisible();
        }

        public boolean canMoveDown() {
            List<Integer> list = this.getSelectedRows();
            return !list.isEmpty() && list.get(list.size() - 1) < this.getLayers().size() - 1;
        }

        public void moveDown() {
            if (!this.canMoveDown()) {
                return;
            }
            List<Integer> list = this.getSelectedRows();
            Collections.reverse(list);
            for (int n : list) {
                Layer layer = this.getLayers().get(n);
                Layer layer2 = this.getLayers().get(n + 1);
                Main.map.mapView.moveLayer(layer, n + 1);
                Main.map.mapView.moveLayer(layer2, n);
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (int n : list) {
                this.selectionModel.addSelectionInterval(n + 1, n + 1);
            }
            this.ensureSelectedIsVisible();
        }

        protected void ensureSelectedIsVisible() {
            int n = this.selectionModel.getMinSelectionIndex();
            if (n < 0) {
                return;
            }
            if (n >= this.getLayers().size()) {
                return;
            }
            Layer layer = this.getLayers().get(n);
            this.fireMakeVisible(n, layer);
        }

        public List<Layer> getPossibleMergeTargets(Layer layer) {
            ArrayList<Layer> arrayList = new ArrayList<Layer>();
            if (layer == null) {
                return arrayList;
            }
            for (Layer layer2 : this.getLayers()) {
                if (layer == layer2 || !layer2.isMergable(layer) || !layer.isMergable(layer2)) continue;
                arrayList.add(layer2);
            }
            return arrayList;
        }

        public List<Layer> getLayers() {
            if (!Main.isDisplayingMapView()) {
                return Collections.emptyList();
            }
            return Main.map.mapView.getAllLayersAsList();
        }

        protected void ensureActiveSelected() {
            if (this.getLayers().isEmpty()) {
                return;
            }
            Layer layer = this.getActiveLayer();
            if (layer != null) {
                int n = this.getLayers().indexOf(layer);
                this.selectionModel.setSelectionInterval(n, n);
                this.ensureSelectedIsVisible();
            } else {
                this.selectionModel.setSelectionInterval(0, 0);
                this.ensureSelectedIsVisible();
            }
        }

        protected Layer getActiveLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            return Main.map.mapView.getActiveLayer();
        }

        @Override
        public int getRowCount() {
            List<Layer> list = this.getLayers();
            if (list == null) {
                return 0;
            }
            return list.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n >= 0 && n < this.getLayers().size()) {
                switch (n2) {
                    case 0: {
                        return this.getLayers().get(n) == this.getActiveLayer();
                    }
                    case 1: {
                        return this.getLayers().get(n);
                    }
                    case 2: {
                        return this.getLayers().get(n);
                    }
                }
                throw new RuntimeException();
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0 || this.getActiveLayer() != this.getLayers().get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Layer layer = this.getLayers().get(n);
            switch (n2) {
                case 0: {
                    Main.map.mapView.setActiveLayer(layer);
                    layer.setVisible(true);
                    break;
                }
                case 1: {
                    layer.setVisible((Boolean)object);
                    break;
                }
                case 2: {
                    layer.setName((String)object);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public void activeLayerChange(final Layer layer, final Layer layer2) {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    int n;
                    if (layer != null && (n = LayerListModel.this.getLayers().indexOf(layer)) >= 0) {
                        LayerListModel.this.fireTableRowsUpdated(n, n);
                    }
                    if (layer2 != null && (n = LayerListModel.this.getLayers().indexOf(layer2)) >= 0) {
                        LayerListModel.this.fireTableRowsUpdated(n, n);
                    }
                    LayerListModel.this.ensureActiveSelected();
                }
            });
        }

        @Override
        public void layerAdded(Layer layer) {
            this.onAddLayer(layer);
        }

        @Override
        public void layerRemoved(Layer layer) {
            this.onRemoveLayer(layer);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() instanceof Layer) {
                Layer layer = (Layer)propertyChangeEvent.getSource();
                int n = this.getLayers().indexOf(layer);
                if (n < 0) {
                    return;
                }
                this.fireRefresh();
            }
        }
    }

    public static interface LayerListModelListener {
        public void makeVisible(int var1, Layer var2);

        public void refresh();
    }

    class MoveDownAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public MoveDownAction() {
            this.putValue("Name", I18n.tr("Move down", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "down"));
            this.putValue("ShortDescription", I18n.tr("Move the selected layer one row down.", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(LayerListDialog.this.model.canMoveDown());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LayerListDialog.this.model.moveDown();
        }
    }

    class MoveUpAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        public MoveUpAction() {
            this.putValue("Name", I18n.tr("Move up", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "up"));
            this.putValue("ShortDescription", I18n.tr("Move the selected layer one row up.", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(LayerListDialog.this.model.canMoveUp());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LayerListDialog.this.model.moveUp();
        }
    }

    class PopupMenuHandler
    extends PopupMenuLauncher {
        PopupMenuHandler() {
        }

        @Override
        public void showMenu(MouseEvent mouseEvent) {
            Layer layer = LayerListDialog.this.getModel().getLayer(LayerListDialog.this.layerList.getSelectedRow());
            this.menu = new LayerListPopup(LayerListDialog.this.getModel().getSelectedLayers(), layer);
            super.showMenu(mouseEvent);
        }
    }

    private static class LayerNameCellEditor
    extends DefaultCellEditor {
        public LayerNameCellEditor(DisableShortcutsOnFocusGainedTextField disableShortcutsOnFocusGainedTextField) {
            super(disableShortcutsOnFocusGainedTextField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            JosmTextField josmTextField = (JosmTextField)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            josmTextField.setText(object == null ? "" : ((Layer)object).getName());
            return josmTextField;
        }
    }

    private class LayerNameCellRenderer
    extends DefaultTableCellRenderer {
        private LayerNameCellRenderer() {
        }

        protected boolean isActiveLayer(Layer layer) {
            if (!Main.isDisplayingMapView()) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            Layer layer = (Layer)object;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, layer.getName(), bl, bl2, n, n2);
            if (this.isActiveLayer(layer)) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            if (Main.pref.getBoolean("dialog.layer.colorname", true)) {
                Color color = layer.getColor(false);
                if (color != null) {
                    Color color2 = null;
                    for (Layer layer2 : LayerListDialog.this.model.getLayers()) {
                        color2 = layer2.getColor(false);
                        if (color2 == null) continue;
                        if (!color2.equals(color)) break;
                        color2 = null;
                    }
                    if (color2 == null) {
                        color = null;
                    }
                }
                if (color == null) {
                    color = Main.pref.getUIColor(bl ? "Table.selectionForeground" : "Table.foreground");
                }
                jLabel.setForeground(color);
            }
            jLabel.setIcon(layer.getIcon());
            jLabel.setToolTipText(layer.getToolTipText());
            return jLabel;
        }
    }

    private static class LayerVisibleCellEditor
    extends DefaultCellEditor {
        final LayerVisibleCheckBox cb;

        public LayerVisibleCellEditor(LayerVisibleCheckBox layerVisibleCheckBox) {
            super(layerVisibleCheckBox);
            this.cb = layerVisibleCheckBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.cb.updateStatus((Layer)object);
            return this.cb;
        }
    }

    private static class LayerVisibleCellRenderer
    implements TableCellRenderer {
        final LayerVisibleCheckBox cb = new LayerVisibleCheckBox();

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.cb.updateStatus((Layer)object);
            }
            return this.cb;
        }
    }

    private static class ActiveLayerCellRenderer
    implements TableCellRenderer {
        final JCheckBox cb = new ActiveLayerCheckBox();

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = object != null && (Boolean)object != false;
            this.cb.setSelected(bl3);
            this.cb.setToolTipText(bl3 ? I18n.tr("this layer is the active layer", new Object[0]) : I18n.tr("this layer is not currently active (click to activate)", new Object[0]));
            return this.cb;
        }
    }

    private static class LayerVisibleCheckBox
    extends JCheckBox {
        private final ImageIcon iconEye;
        private final ImageIcon iconEyeTranslucent;
        private boolean isTranslucent;

        public LayerVisibleCheckBox() {
            this.setHorizontalAlignment(4);
            this.iconEye = ImageProvider.get("dialogs/layerlist", "eye");
            this.iconEyeTranslucent = ImageProvider.get("dialogs/layerlist", "eye-translucent");
            this.setIcon(ImageProvider.get("dialogs/layerlist", "eye-off"));
            this.setPressedIcon(ImageProvider.get("dialogs/layerlist", "eye-pressed"));
            this.setSelectedIcon(this.iconEye);
            this.isTranslucent = false;
        }

        public void setTranslucent(boolean bl) {
            if (this.isTranslucent == bl) {
                return;
            }
            if (bl) {
                this.setSelectedIcon(this.iconEyeTranslucent);
            } else {
                this.setSelectedIcon(this.iconEye);
            }
            this.isTranslucent = bl;
        }

        public void updateStatus(Layer layer) {
            boolean bl = layer.isVisible();
            this.setSelected(bl);
            this.setTranslucent(layer.getOpacity() < 1.0);
            this.setToolTipText(bl ? I18n.tr("layer is currently visible (click to hide layer)", new Object[0]) : I18n.tr("layer is currently hidden (click to show layer)", new Object[0]));
        }
    }

    private static class ActiveLayerCheckBox
    extends JCheckBox {
        public ActiveLayerCheckBox() {
            this.setHorizontalAlignment(0);
            ImageIcon imageIcon = ImageProvider.get("dialogs/layerlist", "blank");
            ImageIcon imageIcon2 = ImageProvider.get("dialogs/layerlist", "active");
            this.setIcon(imageIcon);
            this.setSelectedIcon(imageIcon2);
            this.setRolloverIcon(imageIcon);
            this.setRolloverSelectedIcon(imageIcon2);
            this.setPressedIcon(ImageProvider.get("dialogs/layerlist", "active-pressed"));
        }
    }

    public final class DuplicateAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private Layer layer;

        public DuplicateAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.updateEnabledState();
        }

        public DuplicateAction() {
            this.putValue("Name", I18n.tr("Duplicate", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "duplicatelayer"));
            this.putValue("ShortDescription", I18n.tr("Duplicate this layer", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#DuplicateLayer"));
            this.updateEnabledState();
        }

        /*
         * WARNING - void declaration
         */
        private void duplicate(Layer layer) {
            if (!Main.isDisplayingMapView()) {
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Layer object : Main.map.mapView.getAllLayers()) {
                arrayList.add(object.getName());
            }
            if (layer instanceof OsmDataLayer) {
                void var4_6;
                OsmDataLayer osmDataLayer = (OsmDataLayer)layer;
                String string = I18n.tr("Copy of {0}", osmDataLayer.getName());
                int n = 2;
                while (arrayList.contains(var4_6)) {
                    String string2 = I18n.tr("Copy {1} of {0}", osmDataLayer.getName(), n);
                    ++n;
                }
                Main.main.addLayer(new OsmDataLayer(osmDataLayer.data.clone(), (String)var4_6, null));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.layer != null) {
                this.duplicate(this.layer);
            } else {
                this.duplicate(LayerListDialog.this.getModel().getSelectedLayers().get(0));
            }
        }

        protected boolean isActiveLayer(Layer layer) {
            if (!Main.isDisplayingMapView()) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        @Override
        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().size() == 1) {
                    this.setEnabled(LayerListDialog.this.getModel().getSelectedLayers().get(0) instanceof OsmDataLayer);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(this.layer instanceof OsmDataLayer);
            }
        }
    }

    public final class MergeAction
    extends AbstractAction
    implements IEnabledStateUpdating {
        private Layer layer;

        public MergeAction(Layer layer) throws IllegalArgumentException {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Merge", new Object[0]));
            this.updateEnabledState();
        }

        public MergeAction() {
            this.putValue("Name", I18n.tr("Merge", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "mergedown"));
            this.putValue("ShortDescription", I18n.tr("Merge this layer into another layer", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#MergeLayer"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.layer != null) {
                Main.main.menu.merge.merge(this.layer);
            } else if (LayerListDialog.this.getModel().getSelectedLayers().size() == 1) {
                Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                Main.main.menu.merge.merge(layer);
            } else {
                Main.main.menu.merge.merge(LayerListDialog.this.getModel().getSelectedLayers());
            }
        }

        protected boolean isActiveLayer(Layer layer) {
            if (!Main.isDisplayingMapView()) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        @Override
        public void updateEnabledState() {
            if (this.layer == null) {
                if (LayerListDialog.this.getModel().getSelectedLayers().isEmpty()) {
                    this.setEnabled(false);
                } else if (LayerListDialog.this.getModel().getSelectedLayers().size() > 1) {
                    Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                    for (Layer layer2 : LayerListDialog.this.getModel().getSelectedLayers()) {
                        if (layer2 == layer || layer2.isMergable(layer) && layer.isMergable(layer2)) continue;
                        this.setEnabled(false);
                        return;
                    }
                    this.setEnabled(true);
                } else {
                    Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                    List<Layer> list = LayerListDialog.this.getModel().getPossibleMergeTargets(layer);
                    this.setEnabled(!list.isEmpty());
                }
            } else {
                List<Layer> list = LayerListDialog.this.getModel().getPossibleMergeTargets(this.layer);
                this.setEnabled(!list.isEmpty());
            }
        }
    }

    public final class ActivateLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    MapView.LayerChangeListener,
    MultikeyShortcutAction {
        private Layer layer;
        private Shortcut multikeyShortcut;

        public ActivateLayerAction(Layer layer) {
            this();
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.putValue("Name", I18n.tr("Activate", new Object[0]));
            this.updateEnabledState();
        }

        public ActivateLayerAction() {
            this.putValue("Name", I18n.tr("Activate", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "activate"));
            this.putValue("ShortDescription", I18n.tr("Activate the selected layer", new Object[0]));
            this.multikeyShortcut = Shortcut.registerShortcut("core_multikey:activateLayer", I18n.tr("Multikey: {0}", I18n.tr("Activate layer", new Object[0])), 65, 5005);
            this.multikeyShortcut.setAccelerator(this);
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#ActivateLayer"));
        }

        @Override
        public Shortcut getMultikeyShortcut() {
            return this.multikeyShortcut;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = this.layer != null ? this.layer : LayerListDialog.this.model.getSelectedLayers().get(0);
            this.execute(layer);
        }

        private void execute(Layer layer) {
            Main.map.mapView.setActiveLayer(layer);
            layer.setVisible(true);
        }

        protected boolean isActiveLayer(Layer layer) {
            if (!Main.isDisplayingMapView()) {
                return false;
            }
            return Main.map.mapView.getActiveLayer() == layer;
        }

        @Override
        public void updateEnabledState() {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    if (ActivateLayerAction.this.layer == null) {
                        if (LayerListDialog.this.getModel().getSelectedLayers().size() != 1) {
                            ActivateLayerAction.this.setEnabled(false);
                            return;
                        }
                        Layer layer = LayerListDialog.this.getModel().getSelectedLayers().get(0);
                        ActivateLayerAction.this.setEnabled(!ActivateLayerAction.this.isActiveLayer(layer));
                    } else {
                        ActivateLayerAction.this.setEnabled(!ActivateLayerAction.this.isActiveLayer(ActivateLayerAction.this.layer));
                    }
                }
            });
        }

        @Override
        public void activeLayerChange(Layer layer, Layer layer2) {
            this.updateEnabledState();
        }

        @Override
        public void layerAdded(Layer layer) {
            this.updateEnabledState();
        }

        @Override
        public void layerRemoved(Layer layer) {
            this.updateEnabledState();
        }

        @Override
        public void executeMultikeyAction(int n, boolean bl) {
            Layer layer = LayerListDialog.getLayerForIndex(n);
            if (layer != null) {
                this.execute(layer);
            }
        }

        @Override
        public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
            return LayerListDialog.getLayerInfoByClass(Layer.class);
        }

        @Override
        public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
            return null;
        }
    }

    public final class LayerOpacityAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction {
        private Layer layer;
        private JPopupMenu popup;
        private JSlider slider = new JSlider(1);

        public LayerOpacityAction(Layer layer) throws IllegalArgumentException {
            this();
            this.putValue("Name", I18n.tr("Opacity", new Object[0]));
            CheckParameterUtil.ensureParameterNotNull(layer, "layer");
            this.layer = layer;
            this.updateEnabledState();
        }

        public LayerOpacityAction() {
            this.putValue("Name", I18n.tr("Opacity", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Adjust opacity of the layer.", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/layerlist", "transparency"));
            this.updateEnabledState();
            this.popup = new JPopupMenu();
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    LayerOpacityAction.this.setOpacity((double)LayerOpacityAction.this.slider.getValue() / 100.0);
                }
            });
            this.popup.add(this.slider);
        }

        private void setOpacity(double d) {
            if (!this.isEnabled()) {
                return;
            }
            if (this.layer != null) {
                this.layer.setOpacity(d);
            } else {
                for (Layer layer : LayerListDialog.this.model.getSelectedLayers()) {
                    layer.setOpacity(d);
                }
            }
        }

        private double getOpacity() {
            if (this.layer != null) {
                return this.layer.getOpacity();
            }
            double d = 0.0;
            List<Layer> list = LayerListDialog.this.model.getSelectedLayers();
            for (Layer layer : list) {
                d += layer.getOpacity();
            }
            return d / (double)list.size();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.slider.setValue((int)Math.round(this.getOpacity() * 100.0));
            if (actionEvent.getSource() == LayerListDialog.this.opacityButton) {
                this.popup.show(LayerListDialog.this.opacityButton, 0, LayerListDialog.this.opacityButton.getHeight());
            } else {
                this.popup.show(Main.parent, Main.parent.getWidth() / 2, (Main.parent.getHeight() - this.popup.getHeight()) / 2);
            }
        }

        @Override
        public void updateEnabledState() {
            if (this.layer == null) {
                this.setEnabled(!LayerListDialog.this.getModel().getSelectedLayers().isEmpty());
            } else {
                this.setEnabled(true);
            }
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof LayerOpacityAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    public final class ShowHideLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction,
    MultikeyShortcutAction {
        private WeakReference<Layer> lastLayer;
        private Shortcut multikeyShortcut;

        public ShowHideLayerAction() {
            this.putValue("Name", I18n.tr("Show/hide", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "showhide"));
            this.putValue("ShortDescription", I18n.tr("Toggle visible state of the selected layer.", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#ShowHideLayer"));
            this.multikeyShortcut = Shortcut.registerShortcut("core_multikey:showHideLayer", I18n.tr("Multikey: {0}", I18n.tr("Show/hide layer", new Object[0])), 83, 5005);
            this.multikeyShortcut.setAccelerator(this);
            this.updateEnabledState();
        }

        @Override
        public Shortcut getMultikeyShortcut() {
            return this.multikeyShortcut;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (Layer layer : LayerListDialog.this.model.getSelectedLayers()) {
                layer.toggleVisible();
            }
        }

        @Override
        public void executeMultikeyAction(int n, boolean bl) {
            Layer layer = LayerListDialog.getLayerForIndex(n);
            if (layer != null) {
                layer.toggleVisible();
                this.lastLayer = new WeakReference<Layer>(layer);
            } else if (bl && this.lastLayer != null && LayerListDialog.isLayerValid(layer = (Layer)this.lastLayer.get())) {
                layer.toggleVisible();
            }
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!LayerListDialog.this.model.getSelectedLayers().isEmpty());
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof ShowHideLayerAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
            return LayerListDialog.getLayerInfoByClass(Layer.class);
        }

        @Override
        public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
            if (this.lastLayer != null) {
                return LayerListDialog.getLayerInfo((Layer)this.lastLayer.get());
            }
            return null;
        }
    }

    public final class DeleteLayerAction
    extends AbstractAction
    implements IEnabledStateUpdating,
    Layer.LayerAction {
        public DeleteLayerAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Delete the selected layers.", new Object[0]));
            this.putValue("Name", I18n.tr("Delete", new Object[0]));
            this.putValue("help", HelpUtil.ht("/Dialog/LayerList#DeleteLayer"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<Layer> list = LayerListDialog.this.getModel().getSelectedLayers();
            if (list.isEmpty()) {
                return;
            }
            if (!Main.saveUnsavedModifications(list, false)) {
                return;
            }
            for (Layer layer : list) {
                Main.main.removeLayer(layer);
            }
        }

        @Override
        public void updateEnabledState() {
            this.setEnabled(!LayerListDialog.this.getModel().getSelectedLayers().isEmpty());
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return true;
        }

        public boolean equals(Object object) {
            return object instanceof DeleteLayerAction;
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    protected static interface IEnabledStateUpdating {
        public void updateEnabledState();
    }

    private final class ToggleLayerIndexVisibility
    extends AbstractAction {
        int layerIndex = -1;

        public ToggleLayerIndexVisibility(int n) {
            this.layerIndex = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Layer layer = LayerListDialog.this.model.getLayer(LayerListDialog.this.model.getRowCount() - this.layerIndex - 1);
            if (layer != null) {
                layer.toggleVisible();
            }
        }
    }
}

