/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueCellEditor;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverColumnModel;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolverModel;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;

public class TagConflictResolverTable
extends JTable
implements MultiValueCellEditor.NavigationListener {
    private SelectNextColumnCellAction selectNextColumnCellAction;
    private SelectPreviousColumnCellAction selectPreviousColumnCellAction;

    public TagConflictResolverTable(TagConflictResolverModel tagConflictResolverModel) {
        super(tagConflictResolverModel, new TagConflictResolverColumnModel());
        this.build();
    }

    protected final void build() {
        this.setAutoResizeMode(4);
        this.setSelectionMode(0);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.selectNextColumnCellAction = new SelectNextColumnCellAction();
        this.selectPreviousColumnCellAction = new SelectPreviousColumnCellAction();
        this.getActionMap().put("selectNextColumnCell", this.selectNextColumnCellAction);
        this.getActionMap().put("selectPreviousColumnCell", this.selectPreviousColumnCellAction);
        ((MultiValueCellEditor)this.getColumnModel().getColumn(2).getCellEditor()).addNavigationListeners(this);
        this.setRowHeight((int)new JosmComboBox().getPreferredSize().getHeight());
    }

    @Override
    public void gotoNextDecision() {
        this.selectNextColumnCellAction.run();
    }

    @Override
    public void gotoPreviousDecision() {
        this.selectPreviousColumnCellAction.run();
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void run() {
            int n = TagConflictResolverTable.this.getSelectedColumn();
            int n2 = TagConflictResolverTable.this.getSelectedRow();
            if (TagConflictResolverTable.this.getCellEditor() != null) {
                TagConflictResolverTable.this.getCellEditor().stopCellEditing();
            }
            if ((n > 0 || n2 > 0) && n2 > 0) {
                n = 2;
                --n2;
            }
            TagConflictResolverTable.this.changeSelection(n2, n, false, false);
            if (TagConflictResolverTable.this.editCellAt(TagConflictResolverTable.this.getSelectedRow(), TagConflictResolverTable.this.getSelectedColumn())) {
                TagConflictResolverTable.this.getEditorComponent().requestFocusInWindow();
            }
        }
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        public void run() {
            int n = TagConflictResolverTable.this.getSelectedColumn();
            int n2 = TagConflictResolverTable.this.getSelectedRow();
            if (TagConflictResolverTable.this.getCellEditor() != null) {
                TagConflictResolverTable.this.getCellEditor().stopCellEditing();
            }
            if (n == 2 && n2 < TagConflictResolverTable.this.getRowCount() - 1) {
                ++n2;
            } else if (n2 < TagConflictResolverTable.this.getRowCount() - 1) {
                n = 2;
                ++n2;
            }
            TagConflictResolverTable.this.changeSelection(n2, n, false, false);
            if (TagConflictResolverTable.this.editCellAt(TagConflictResolverTable.this.getSelectedRow(), TagConflictResolverTable.this.getSelectedColumn())) {
                TagConflictResolverTable.this.getEditorComponent().requestFocusInWindow();
            }
        }
    }
}

