/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueDecisionType;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueResolutionDecision;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.I18n;

public class MultiValueCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JosmComboBox<Object> editor;
    private DefaultComboBoxModel<Object> editorModel = new DefaultComboBoxModel();
    private CopyOnWriteArrayList<NavigationListener> listeners;

    public void addNavigationListeners(NavigationListener navigationListener) {
        if (navigationListener != null) {
            this.listeners.addIfAbsent(navigationListener);
        }
    }

    public void removeNavigationListeners(NavigationListener navigationListener) {
        this.listeners.remove(navigationListener);
    }

    protected void fireGotoNextDecision() {
        for (NavigationListener navigationListener : this.listeners) {
            navigationListener.gotoNextDecision();
        }
    }

    protected void fireGotoPreviousDecision() {
        for (NavigationListener navigationListener : this.listeners) {
            navigationListener.gotoPreviousDecision();
        }
    }

    public MultiValueCellEditor() {
        this.editor = new JosmComboBox<Object>(this.editorModel){

            @Override
            public void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 10) {
                    MultiValueCellEditor.this.fireGotoNextDecision();
                } else if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 9) {
                    if (keyEvent.isShiftDown()) {
                        MultiValueCellEditor.this.fireGotoPreviousDecision();
                    } else {
                        MultiValueCellEditor.this.fireGotoNextDecision();
                    }
                } else if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                    if (MultiValueCellEditor.this.editorModel.getIndexOf((Object)MultiValueDecisionType.KEEP_NONE) > 0) {
                        MultiValueCellEditor.this.editorModel.setSelectedItem((Object)MultiValueDecisionType.KEEP_NONE);
                        MultiValueCellEditor.this.fireGotoNextDecision();
                    }
                } else if (keyEvent.getID() == 401 && keyEvent.getKeyCode() == 27) {
                    MultiValueCellEditor.this.cancelCellEditing();
                }
                super.processKeyEvent(keyEvent);
            }
        };
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MultiValueCellEditor.this.editor.showPopup();
            }
        });
        this.editor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    MultiValueCellEditor.this.fireEditingStopped();
                }
            }
        });
        this.editor.setRenderer(new EditorCellRenderer());
        this.listeners = new CopyOnWriteArrayList();
    }

    protected void initEditor(MultiValueResolutionDecision multiValueResolutionDecision) {
        this.editorModel.removeAllElements();
        if (!multiValueResolutionDecision.isDecided()) {
            this.editorModel.addElement((Object)MultiValueDecisionType.UNDECIDED);
        }
        for (String string : multiValueResolutionDecision.getValues()) {
            this.editorModel.addElement(string);
        }
        if (multiValueResolutionDecision.canKeepNone()) {
            this.editorModel.addElement((Object)MultiValueDecisionType.KEEP_NONE);
        }
        if (multiValueResolutionDecision.canKeepAll()) {
            this.editorModel.addElement((Object)MultiValueDecisionType.KEEP_ALL);
        }
        switch (multiValueResolutionDecision.getDecisionType()) {
            case UNDECIDED: {
                this.editor.setSelectedItem((Object)MultiValueDecisionType.UNDECIDED);
                break;
            }
            case KEEP_ONE: {
                this.editor.setSelectedItem(multiValueResolutionDecision.getChosenValue());
                break;
            }
            case KEEP_NONE: {
                this.editor.setSelectedItem((Object)MultiValueDecisionType.KEEP_NONE);
                break;
            }
            case KEEP_ALL: {
                this.editor.setSelectedItem((Object)MultiValueDecisionType.KEEP_ALL);
            }
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        MultiValueResolutionDecision multiValueResolutionDecision = (MultiValueResolutionDecision)object;
        this.initEditor(multiValueResolutionDecision);
        this.editor.requestFocus();
        return this.editor;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getSelectedItem();
    }

    private static class EditorCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        public EditorCellRenderer() {
            this.setOpaque(true);
        }

        protected void renderColors(boolean bl) {
            if (bl) {
                this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
            } else {
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
                this.setBackground(UIManager.getColor("ComboBox.background"));
            }
        }

        protected void renderValue(Object object) {
            this.setFont(UIManager.getFont("ComboBox.font"));
            if (String.class.isInstance(object)) {
                this.setText((String)String.class.cast(object));
            } else if (MultiValueDecisionType.class.isInstance(object)) {
                switch ((MultiValueDecisionType)((Object)MultiValueDecisionType.class.cast(object))) {
                    case UNDECIDED: {
                        this.setText(I18n.tr("Choose a value", new Object[0]));
                        this.setFont(UIManager.getFont("ComboBox.font").deriveFont(3));
                        break;
                    }
                    case KEEP_NONE: {
                        this.setText(I18n.tr("none", new Object[0]));
                        this.setFont(UIManager.getFont("ComboBox.font").deriveFont(3));
                        break;
                    }
                    case KEEP_ALL: {
                        this.setText(I18n.tr("all", new Object[0]));
                        this.setFont(UIManager.getFont("ComboBox.font").deriveFont(3));
                        break;
                    }
                }
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            this.renderColors(bl);
            this.renderValue(object);
            return this;
        }
    }

    public static interface NavigationListener {
        public void gotoNextDecision();

        public void gotoPreviousDecision();
    }
}

