/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public abstract class UnconnectedWays
extends Test {
    protected static final int UNCONNECTED_WAYS = 1301;
    protected static final String PREFIX = "validator." + UnconnectedWays.class.getSimpleName();
    private Set<MyWaySegment> ways;
    private QuadBuckets<Node> endnodes;
    private QuadBuckets<Node> endnodes_highway;
    private QuadBuckets<Node> middlenodes;
    private Set<Node> othernodes;
    private Area dsArea;
    private double mindist;
    private double minmiddledist;

    public UnconnectedWays(String string) {
        super(string, I18n.tr("This test checks if a way has an endpoint very near to another way.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.ways = new HashSet<MyWaySegment>();
        this.endnodes = new QuadBuckets();
        this.endnodes_highway = new QuadBuckets();
        this.middlenodes = new QuadBuckets();
        this.othernodes = new HashSet<Node>();
        this.mindist = Main.pref.getDouble(PREFIX + ".node_way_distance", 10.0);
        this.minmiddledist = Main.pref.getDouble(PREFIX + ".way_way_distance", 0.0);
        this.dsArea = Main.main == null || !Main.main.hasEditLayer() ? null : Main.main.getCurrentDataSet().getDataSourceArea();
    }

    protected Map<Node, Way> getWayEndNodesNearOtherHighway() {
        HashMap<Node, Way> hashMap = new HashMap<Node, Way>();
        for (int i = 0; i < 1; ++i) {
            for (MyWaySegment myWaySegment : this.ways) {
                if (this.isCanceled()) {
                    hashMap.clear();
                    return hashMap;
                }
                for (Node node : myWaySegment.nearbyNodes(this.mindist)) {
                    if (node == null || !myWaySegment.highway || !this.endnodes_highway.contains(node) || node.hasTag("highway", "turning_circle", "bus_stop") || node.hasTag("amenity", "parking_entrance") || node.hasTag("railway", "buffer_stop") || node.isKeyTrue("noexit") || node.hasKey("entrance") || node.hasKey("barrier") || node.isConnectedTo(myWaySegment.w.getNodes(), 3, null)) continue;
                    hashMap.put(node, myWaySegment.w);
                }
            }
        }
        return hashMap;
    }

    protected Map<Node, Way> getWayEndNodesNearOtherWay() {
        HashMap<Node, Way> hashMap = new HashMap<Node, Way>();
        for (MyWaySegment myWaySegment : this.ways) {
            if (this.isCanceled()) {
                hashMap.clear();
                return hashMap;
            }
            for (Node node : myWaySegment.nearbyNodes(this.mindist)) {
                if (node.isConnectedTo(myWaySegment.w.getNodes(), 3, null)) continue;
                if (this.endnodes_highway.contains(node) && !myWaySegment.highway && !myWaySegment.w.concernsArea()) {
                    hashMap.put(node, myWaySegment.w);
                    continue;
                }
                if (!this.endnodes.contains(node) || myWaySegment.w.concernsArea()) continue;
                hashMap.put(node, myWaySegment.w);
            }
        }
        return hashMap;
    }

    protected Map<Node, Way> getWayNodesNearOtherWay() {
        HashMap<Node, Way> hashMap = new HashMap<Node, Way>();
        for (MyWaySegment myWaySegment : this.ways) {
            if (this.isCanceled()) {
                hashMap.clear();
                return hashMap;
            }
            for (Node node : myWaySegment.nearbyNodes(this.minmiddledist)) {
                if (node.isConnectedTo(myWaySegment.w.getNodes(), 3, null) || !this.middlenodes.contains(node)) continue;
                hashMap.put(node, myWaySegment.w);
            }
        }
        return hashMap;
    }

    protected Map<Node, Way> getConnectedWayEndNodesNearOtherWay() {
        HashMap<Node, Way> hashMap = new HashMap<Node, Way>();
        for (MyWaySegment myWaySegment : this.ways) {
            if (this.isCanceled()) {
                hashMap.clear();
                return hashMap;
            }
            for (Node node : myWaySegment.nearbyNodes(this.minmiddledist)) {
                if (node.isConnectedTo(myWaySegment.w.getNodes(), 3, null) || !this.othernodes.contains(node)) continue;
                hashMap.put(node, myWaySegment.w);
            }
        }
        return hashMap;
    }

    protected final void addErrors(Severity severity, Map<Node, Way> map, String string) {
        for (Map.Entry<Node, Way> entry : map.entrySet()) {
            this.errors.add(new TestError(this, severity, string, 1301, Arrays.asList(entry.getKey(), entry.getValue()), Arrays.asList(entry.getKey())));
        }
    }

    @Override
    public void endTest() {
        this.addErrors(Severity.WARNING, this.getWayEndNodesNearOtherHighway(), I18n.tr("Way end node near other highway", new Object[0]));
        this.addErrors(Severity.WARNING, this.getWayEndNodesNearOtherWay(), I18n.tr("Way end node near other way", new Object[0]));
        if (this.minmiddledist > 0.0) {
            this.addErrors(Severity.OTHER, this.getWayNodesNearOtherWay(), I18n.tr("Way node near other way", new Object[0]));
            this.addErrors(Severity.OTHER, this.getConnectedWayEndNodesNearOtherWay(), I18n.tr("Connected way end node near other way", new Object[0]));
        }
        this.ways = null;
        this.endnodes = null;
        this.endnodes_highway = null;
        this.middlenodes = null;
        this.othernodes = null;
        this.dsArea = null;
        super.endTest();
    }

    List<MyWaySegment> getWaySegments(Way way) {
        ArrayList<MyWaySegment> arrayList = new ArrayList<MyWaySegment>();
        if (!way.isUsable() || way.hasKey("barrier") || way.hasTag("natural", "cliff")) {
            return arrayList;
        }
        int n = way.getNodesCount();
        if (n < 2) {
            return arrayList;
        }
        for (int i = 1; i < n; ++i) {
            if (i < n - 1) {
                this.addNode(way.getNode(i), this.middlenodes);
            }
            Node node = way.getNode(i - 1);
            Node node2 = way.getNode(i);
            if (!node.isDrawable() || !node2.isDrawable()) continue;
            MyWaySegment myWaySegment = new MyWaySegment(way, node, node2);
            if (myWaySegment.isBoundary || myWaySegment.isAbandoned) continue;
            arrayList.add(myWaySegment);
        }
        return arrayList;
    }

    @Override
    public void visit(Way way) {
        if (!(way.getNodesCount() <= 0 || way.hasKey("addr:interpolation") || way.hasTag("highway", "platform") || way.hasTag("railway", "platform"))) {
            this.ways.addAll(this.getWaySegments(way));
            QuadBuckets<Node> quadBuckets = this.endnodes;
            if (way.hasKey("highway") || way.hasKey("railway")) {
                quadBuckets = this.endnodes_highway;
            }
            this.addNode(way.firstNode(), quadBuckets);
            this.addNode(way.lastNode(), quadBuckets);
        }
    }

    private void addNode(Node node, QuadBuckets<Node> quadBuckets) {
        boolean bl = this.middlenodes.contains(node);
        boolean bl2 = this.endnodes.contains(node);
        boolean bl3 = this.endnodes_highway.contains(node);
        boolean bl4 = this.othernodes.contains(node);
        if (!(bl || bl2 || bl4 || bl3)) {
            quadBuckets.add(node);
        } else if (!bl4) {
            this.othernodes.add(node);
            if (bl2) {
                this.endnodes.remove(node);
            } else if (bl3) {
                this.endnodes_highway.remove(node);
            } else {
                this.middlenodes.remove(node);
            }
        }
    }

    private class MyWaySegment {
        private final Line2D line;
        public final Way w;
        public final boolean isAbandoned;
        public final boolean isBoundary;
        public final boolean highway;
        private final double len;
        private Set<Node> nearbyNodeCache;
        double nearbyNodeCacheDist = -1.0;
        final Node n1;
        final Node n2;

        public MyWaySegment(Way way, Node node, Node node2) {
            this.w = way;
            String string = way.get("railway");
            String string2 = way.get("highway");
            this.isAbandoned = "abandoned".equals(string) || way.isKeyTrue("disused");
            this.highway = (string2 != null || string != null) && !this.isAbandoned;
            this.isBoundary = !this.highway && "administrative".equals(way.get("boundary"));
            this.line = new Line2D.Double(node.getEastNorth().east(), node.getEastNorth().north(), node2.getEastNorth().east(), node2.getEastNorth().north());
            this.len = this.line.getP1().distance(this.line.getP2());
            this.n1 = node;
            this.n2 = node2;
        }

        public boolean nearby(Node node, double d) {
            if (this.w == null) {
                Main.debug("way null");
                return false;
            }
            if (this.w.containsNode(node)) {
                return false;
            }
            if (node.isKeyTrue("noexit")) {
                return false;
            }
            EastNorth eastNorth = node.getEastNorth();
            if (eastNorth == null) {
                return false;
            }
            Point2D.Double double_ = new Point2D.Double(eastNorth.east(), eastNorth.north());
            if (this.line.getP1().distance(double_) > this.len + d) {
                return false;
            }
            if (this.line.getP2().distance(double_) > this.len + d) {
                return false;
            }
            return this.line.ptSegDist(double_) < d;
        }

        public List<LatLon> getBounds(double d) {
            double d2;
            double d3;
            double d4;
            double d5 = this.n1.getCoor().lon();
            if (d5 > (d4 = this.n2.getCoor().lon())) {
                d3 = d5;
                d5 = d4;
                d4 = d3;
            }
            if ((d3 = this.n1.getCoor().lat()) > (d2 = this.n2.getCoor().lat())) {
                double d6 = d3;
                d3 = d2;
                d2 = d6;
            }
            LatLon latLon = new LatLon(d2 + d, d5 - d);
            LatLon latLon2 = new LatLon(d3 - d, d4 + d);
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>(2);
            arrayList.add(latLon);
            arrayList.add(latLon2);
            return arrayList;
        }

        public Collection<Node> nearbyNodes(double d) {
            if (d > this.nearbyNodeCacheDist) {
                this.nearbyNodeCache = null;
            }
            if (this.nearbyNodeCache != null) {
                if (this.nearbyNodeCacheDist > d) {
                    HashSet<Node> hashSet = new HashSet<Node>(this.nearbyNodeCache);
                    HashSet<Node> hashSet2 = new HashSet<Node>(this.nearbyNodeCache);
                    for (Node node : hashSet2) {
                        if (this.nearby(node, d)) continue;
                        hashSet.remove(node);
                    }
                    return hashSet;
                }
                return this.nearbyNodeCache;
            }
            this.nearbyNodeCache = null;
            List<LatLon> list = this.getBounds(d);
            List list2 = UnconnectedWays.this.endnodes_highway.search(new BBox(list.get(0), list.get(1)));
            list2.addAll(UnconnectedWays.this.endnodes.search(new BBox(list.get(0), list.get(1))));
            for (Node node : list2) {
                if (!this.nearby(node, d) || !node.getCoor().isIn(UnconnectedWays.this.dsArea)) continue;
                if (this.nearbyNodeCache == null) {
                    this.nearbyNodeCache = new HashSet<Node>();
                }
                this.nearbyNodeCache.add(node);
            }
            this.nearbyNodeCacheDist = d;
            if (this.nearbyNodeCache == null) {
                this.nearbyNodeCache = Collections.emptySet();
            }
            return this.nearbyNodeCache;
        }
    }

    public static class UnconnectedPower
    extends UnconnectedWays {
        public UnconnectedPower() {
            super(I18n.tr("Unconnected power ways", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && osmPrimitive.hasTag("power", "line", "minor_line", "cable");
        }
    }

    public static class UnconnectedNaturalOrLanduse
    extends UnconnectedWays {
        public UnconnectedNaturalOrLanduse() {
            super(I18n.tr("Unconnected natural lands and landuses", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && (osmPrimitive.hasKey("natural") || osmPrimitive.hasKey("landuse"));
        }
    }

    public static class UnconnectedWaterways
    extends UnconnectedWays {
        public UnconnectedWaterways() {
            super(I18n.tr("Unconnected waterways", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && osmPrimitive.hasKey("waterway");
        }
    }

    public static class UnconnectedRailways
    extends UnconnectedWays {
        public UnconnectedRailways() {
            super(I18n.tr("Unconnected railways", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && osmPrimitive.hasKey("railway");
        }
    }

    public static class UnconnectedHighways
    extends UnconnectedWays {
        public UnconnectedHighways() {
            super(I18n.tr("Unconnected highways", new Object[0]));
        }

        @Override
        public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
            return super.isPrimitiveUsable(osmPrimitive) && osmPrimitive.hasKey("highway");
        }
    }
}

