/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.FixableTestError;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.EmailValidator;
import org.openstreetmap.josm.data.validation.routines.UrlValidator;
import org.openstreetmap.josm.tools.I18n;

public class InternetTags
extends Test {
    protected static final int INVALID_URL = 3301;
    protected static final int INVALID_EMAIL = 3302;
    public static String[] URL_KEYS = new String[]{"url", "source:url", "website", "contact:website", "heritage:website", "source:website"};
    public static String[] EMAIL_KEYS = new String[]{"email", "contact:email"};

    public InternetTags() {
        super(I18n.tr("Internet tags", new Object[0]), I18n.tr("Checks for errors in internet-related tags.", new Object[0]));
    }

    private boolean doTest(OsmPrimitive osmPrimitive, String string, String[] stringArray, AbstractValidator abstractValidator, int n) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            if (abstractValidator.isValid(osmPrimitive.get(string))) break;
            String string3 = I18n.tr("''{0}'': {1}", string, abstractValidator.getErrorMessage());
            String string4 = abstractValidator.getFix();
            TestError testError = string4 != null ? new FixableTestError((Test)this, Severity.WARNING, string3, n, osmPrimitive, (Command)new ChangePropertyCommand(osmPrimitive, string, string4)) : new TestError((Test)this, Severity.WARNING, string3, n, osmPrimitive);
            return this.errors.add(testError);
        }
        return false;
    }

    private void test(OsmPrimitive osmPrimitive) {
        for (String string : osmPrimitive.keySet()) {
            if (this.doTest(osmPrimitive, string, URL_KEYS, UrlValidator.getInstance(), 3301)) continue;
            this.doTest(osmPrimitive, string, EMAIL_KEYS, EmailValidator.getInstance(), 3302);
        }
    }

    @Override
    public void visit(Node node) {
        this.test(node);
    }

    @Override
    public void visit(Way way) {
        this.test(way);
    }

    @Override
    public void visit(Relation relation) {
        this.test(relation);
    }
}

