/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public class Highways
extends Test {
    protected static final int WRONG_ROUNDABOUT_HIGHWAY = 2701;
    protected static final int MISSING_PEDESTRIAN_CROSSING = 2702;
    protected static final int SOURCE_MAXSPEED_UNKNOWN_COUNTRY_CODE = 2703;
    protected static final int SOURCE_MAXSPEED_UNKNOWN_CONTEXT = 2704;
    protected static final int SOURCE_MAXSPEED_CONTEXT_MISMATCH_VS_MAXSPEED = 2705;
    protected static final int SOURCE_MAXSPEED_CONTEXT_MISMATCH_VS_HIGHWAY = 2706;
    protected static final int SOURCE_WRONG_LINK = 2707;
    protected static final List<String> CLASSIFIED_HIGHWAYS = Arrays.asList("motorway", "motorway_link", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "residential", "living_street");
    protected static final List<String> KNOWN_SOURCE_MAXSPEED_CONTEXTS = Arrays.asList("urban", "rural", "zone", "zone30", "zone:30", "nsl_single", "nsl_dual", "motorway", "trunk", "living_street", "bicycle_road");
    protected static final List<String> ISO_COUNTRIES = Arrays.asList(Locale.getISOCountries());
    boolean leftByPedestrians = false;
    boolean leftByCyclists = false;
    boolean leftByCars = false;
    int pedestrianWays = 0;
    int cyclistWays = 0;
    int carsWays = 0;

    public Highways() {
        super(I18n.tr("Highways", new Object[0]), I18n.tr("Performs semantic checks on highways.", new Object[0]));
    }

    @Override
    public void visit(Node node) {
        if (node.isUsable()) {
            if (!node.hasTag("highway", "crossing") && !node.hasTag("crossing", "no") && node.isReferredByWays(2)) {
                this.testMissingPedestrianCrossing(node);
            }
            if (node.hasKey("source:maxspeed")) {
                this.testSourceMaxspeed(node, false);
            }
        }
    }

    @Override
    public void visit(Way way) {
        if (way.isUsable()) {
            if (way.hasKey("highway") && CLASSIFIED_HIGHWAYS.contains(way.get("highway")) && way.hasKey("junction") && "roundabout".equals(way.get("junction"))) {
                this.testWrongRoundabout(way);
            }
            if (way.hasKey("source:maxspeed")) {
                this.testSourceMaxspeed(way, true);
            }
            this.testHighwayLink(way);
        }
    }

    private void testWrongRoundabout(Way way) {
        Object object;
        HashMap<Object, ArrayList<Comparable<OsmPrimitive>>> hashMap = new HashMap<Object, ArrayList<Comparable<OsmPrimitive>>>();
        for (Node object2 : new HashSet<Node>(way.getNodes())) {
            for (Comparable<OsmPrimitive> comparable : Utils.filteredCollection(object2.getReferrers(), Way.class)) {
                object = ((AbstractPrimitive)((Object)comparable)).get("highway");
                if (comparable == way || object == null || ((String)object).endsWith("_link")) continue;
                ArrayList<Comparable<OsmPrimitive>> arrayList = (ArrayList<Comparable<OsmPrimitive>>)hashMap.get(object);
                if (arrayList == null) {
                    arrayList = new ArrayList<Comparable<OsmPrimitive>>();
                    hashMap.put(object, arrayList);
                }
                arrayList.add(comparable);
            }
        }
        for (String string : CLASSIFIED_HIGHWAYS) {
            Comparable<OsmPrimitive> comparable;
            List list = (List)hashMap.get(string);
            if (list == null || list.size() < 2) continue;
            comparable = OsmUtils.getOsmBoolean(((Way)list.get(0)).get("oneway"));
            object = OsmUtils.getOsmBoolean(((Way)list.get(1)).get("oneway"));
            if (list.size() <= 2 && comparable != null && object != null && ((Boolean)comparable).booleanValue() && ((Boolean)object).booleanValue()) continue;
            if (way.get("highway").equals(string)) break;
            this.errors.add(new WrongRoundaboutHighway(way, string));
            break;
        }
    }

    public static boolean isHighwayLinkOkay(final Way way) {
        final String string = way.get("highway");
        if (string == null || !string.endsWith("_link")) {
            return true;
        }
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        if (way.isClosed()) {
            for (Node node : way.getNodes()) {
                hashSet.addAll(node.getReferrers());
            }
        } else {
            hashSet.addAll(way.firstNode().getReferrers());
            hashSet.addAll(way.lastNode().getReferrers());
        }
        return Utils.exists(Utils.filteredCollection(hashSet, Way.class), new Predicate<Way>(){

            @Override
            public boolean evaluate(Way way2) {
                return !way.equals(way2) && way2.hasTag("highway", string, string.replaceAll("_link$", ""));
            }
        });
    }

    private void testHighwayLink(Way way) {
        if (!Highways.isHighwayLinkOkay(way)) {
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Highway link is not linked to adequate highway/link", new Object[0]), 2707, way));
        }
    }

    private void testMissingPedestrianCrossing(Node node) {
        this.leftByPedestrians = false;
        this.leftByCyclists = false;
        this.leftByCars = false;
        this.pedestrianWays = 0;
        this.cyclistWays = 0;
        this.carsWays = 0;
        for (Way way : OsmPrimitive.getFilteredList(node.getReferrers(), Way.class)) {
            String string = way.get("highway");
            if (string == null) continue;
            if ("footway".equals(string) || "path".equals(string)) {
                this.handlePedestrianWay(node, way);
                if (way.hasTag("bicycle", "yes", "designated")) {
                    this.handleCyclistWay(node, way);
                }
            } else if ("cycleway".equals(string)) {
                this.handleCyclistWay(node, way);
                if (way.hasTag("foot", "yes", "designated")) {
                    this.handlePedestrianWay(node, way);
                }
            } else if (CLASSIFIED_HIGHWAYS.contains(string)) {
                this.handleCarWay(node, way);
            }
            if (!this.leftByPedestrians && !this.leftByCyclists || !this.leftByCars) continue;
            this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Missing pedestrian crossing information", new Object[0]), 2702, node));
            return;
        }
    }

    private void handleCarWay(Node node, Way way) {
        ++this.carsWays;
        if (!way.isFirstLastNode(node) || this.carsWays > 1) {
            this.leftByCars = true;
        }
    }

    private void handleCyclistWay(Node node, Way way) {
        ++this.cyclistWays;
        if (!way.isFirstLastNode(node) || this.cyclistWays > 1) {
            this.leftByCyclists = true;
        }
    }

    private void handlePedestrianWay(Node node, Way way) {
        ++this.pedestrianWays;
        if (!way.isFirstLastNode(node) || this.pedestrianWays > 1) {
            this.leftByPedestrians = true;
        }
    }

    private void testSourceMaxspeed(OsmPrimitive osmPrimitive, boolean bl) {
        String string = osmPrimitive.get("source:maxspeed");
        if (string.matches("[A-Z]{2}:.+")) {
            String string2;
            int n = string.indexOf(58);
            String string3 = string.substring(0, n);
            if (!ISO_COUNTRIES.contains(string3)) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Unknown country code: {0}", string3), 2703, osmPrimitive));
            }
            if (!KNOWN_SOURCE_MAXSPEED_CONTEXTS.contains(string2 = string.substring(n + 1))) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Unknown source:maxspeed context: {0}", string2), 2704, osmPrimitive));
            }
        }
    }

    @Override
    public boolean isFixable(TestError testError) {
        return testError instanceof WrongRoundaboutHighway;
    }

    @Override
    public Command fixError(TestError testError) {
        Iterator<? extends OsmPrimitive> iterator;
        if (testError instanceof WrongRoundaboutHighway && (iterator = testError.getPrimitives().iterator()).hasNext()) {
            return new ChangePropertyCommand(iterator.next(), "highway", ((WrongRoundaboutHighway)testError).correctValue);
        }
        return null;
    }

    protected class WrongRoundaboutHighway
    extends TestError {
        public final String correctValue;

        public WrongRoundaboutHighway(Way way, String string) {
            super((Test)Highways.this, Severity.WARNING, I18n.tr("Incorrect roundabout (highway: {0} instead of {1})", way.get("highway"), string), 2701, way);
            this.correctValue = string;
        }
    }
}

