/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class DuplicateWay
extends Test {
    protected static final int DUPLICATE_WAY = 1401;
    protected static final int SAME_WAY = 1402;
    private MultiMap<WayPair, OsmPrimitive> ways;
    private MultiMap<WayPairNoTags, OsmPrimitive> waysNoTags;
    private Set<Integer> knownHashCodes;

    public DuplicateWay() {
        super(I18n.tr("Duplicated ways", new Object[0]), I18n.tr("This test checks that there are no ways with same node coordinates and optionally also same tags.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.ways = new MultiMap(1000);
        this.waysNoTags = new MultiMap(1000);
        this.knownHashCodes = new HashSet<Integer>(1000);
    }

    @Override
    public void endTest() {
        Object object;
        super.endTest();
        for (Set<OsmPrimitive> set : this.ways.values()) {
            if (set.size() <= 1) continue;
            object = new TestError((Test)this, Severity.ERROR, I18n.tr("Duplicated ways", new Object[0]), 1401, set);
            this.errors.add(object);
        }
        for (Set<OsmPrimitive> set : this.waysNoTags.values()) {
            if (set.size() <= 1) continue;
            object = null;
            boolean bl = true;
            for (OsmPrimitive osmPrimitive : set) {
                if (object == null) {
                    object = osmPrimitive.getKeys();
                    this.removeUninterestingKeys((Map<String, String>)object);
                    continue;
                }
                Map<String, String> map = osmPrimitive.getKeys();
                this.removeUninterestingKeys(map);
                if (map.equals(object)) continue;
                bl = false;
                break;
            }
            if (bl) continue;
            TestError testError = new TestError((Test)this, Severity.WARNING, I18n.tr("Ways with same position", new Object[0]), 1402, set);
            this.errors.add(testError);
        }
        this.ways = null;
        this.waysNoTags = null;
        this.knownHashCodes = null;
    }

    public void removeUninterestingKeys(Map<String, String> map) {
        for (String string : OsmPrimitive.getDiscardableKeys()) {
            map.remove(string);
        }
    }

    @Override
    public void visit(Way way) {
        int n;
        int n2;
        if (!way.isUsable()) {
            return;
        }
        List<Node> list = way.getNodes();
        ArrayList<Node> arrayList2 = new ArrayList<Node>(list.size());
        if (way.isClosed()) {
            int n3 = 0;
            long l = list.get(0).getUniqueId();
            for (n2 = 1; n2 < list.size(); ++n2) {
                if (list.get(n2).getUniqueId() >= l) continue;
                l = list.get(n2).getUniqueId();
                n3 = n2;
            }
            for (n2 = n3; n2 < list.size() - 1; ++n2) {
                arrayList2.add(list.get(n2));
            }
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList2.add(list.get(n2));
            }
            arrayList2.add(list.get(n3));
        } else {
            arrayList2.addAll(list);
        }
        ArrayList<LatLon> arrayList3 = new ArrayList<LatLon>(arrayList2.size());
        for (Node arrayList4 : arrayList2) {
            arrayList3.add(arrayList4.getCoor());
        }
        if (!way.hasDirectionKeys() && !this.knownHashCodes.contains(n = arrayList3.hashCode())) {
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>(arrayList3);
            Collections.reverse(arrayList);
            n2 = arrayList.hashCode();
            if (!this.knownHashCodes.contains(n2)) {
                this.knownHashCodes.add(n);
            } else {
                arrayList3 = arrayList;
            }
        }
        Map<String, String> map = way.getKeys();
        this.removeUninterestingKeys(map);
        WayPair wayPair = new WayPair(arrayList3, map);
        this.ways.put(wayPair, way);
        WayPairNoTags wayPairNoTags = new WayPairNoTags(arrayList3);
        this.waysNoTags.put(wayPairNoTags, way);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Command fixError(TestError testError) {
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way) || osmPrimitive.isDeleted()) continue;
            hashSet.add((Way)osmPrimitive);
        }
        if (hashSet.size() < 2) {
            return null;
        }
        long l = 0L;
        Way way = (Way)hashSet.iterator().next();
        for (Way object2 : hashSet) {
            if (object2.isNew() || l != 0L && object2.getId() >= l) continue;
            l = object2.getId();
            way = object2;
        }
        Object object3 = null;
        Object var8_10 = null;
        for (Way way2 : hashSet) {
            List<Relation> list = OsmPrimitive.getFilteredList(way2.getReferrers(), Relation.class);
            if (list.isEmpty()) continue;
            if (object3 != null) {
                throw new AssertionError((Object)"Cannot fix duplicate Ways: More than one way is relation member.");
            }
            object3 = way2;
            List<Relation> list2 = list;
        }
        LinkedList linkedList = new LinkedList();
        if (object3 != null && way != object3) {
            void var8_11;
            for (List<Relation> list : var8_11) {
                Relation relation = new Relation((Relation)((Object)list));
                for (int i = 0; i < relation.getMembers().size(); ++i) {
                    RelationMember relationMember = relation.getMember(i);
                    if (!((OsmPrimitive)object3).equals(relationMember.getMember())) continue;
                    relation.setMember(i, new RelationMember(relationMember.getRole(), way));
                }
                linkedList.add(new ChangeCommand((OsmPrimitive)((Object)list), relation));
            }
        }
        hashSet.remove(way);
        linkedList.add(new DeleteCommand(hashSet));
        return new SequenceCommand(I18n.tr("Delete duplicate ways", new Object[0]), linkedList);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (!(testError.getTester() instanceof DuplicateWay)) {
            return false;
        }
        if (testError.getCode() != 1401) {
            return false;
        }
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (OsmPrimitive object : collection) {
            if (!(object instanceof Way)) continue;
            hashSet.add((Way)object);
        }
        if (hashSet.size() < 2) {
            return false;
        }
        int n = 0;
        for (Way way : hashSet) {
            List<Relation> list = OsmPrimitive.getFilteredList(way.getReferrers(), Relation.class);
            if (list.isEmpty()) continue;
            ++n;
        }
        return n <= 1;
    }

    private static class WayPairNoTags {
        private final List<LatLon> coor;

        public WayPairNoTags(List<LatLon> list) {
            this.coor = list;
        }

        public int hashCode() {
            return this.coor.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof WayPairNoTags)) {
                return false;
            }
            WayPairNoTags wayPairNoTags = (WayPairNoTags)object;
            return wayPairNoTags.coor.equals(this.coor);
        }
    }

    private static class WayPair {
        private final List<LatLon> coor;
        private final Map<String, String> keys;

        public WayPair(List<LatLon> list, Map<String, String> map) {
            this.coor = list;
            this.keys = map;
        }

        public int hashCode() {
            return this.coor.hashCode() + this.keys.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof WayPair)) {
                return false;
            }
            WayPair wayPair = (WayPair)object;
            return wayPair.coor.equals(this.coor) && wayPair.keys.equals(this.keys);
        }
    }
}

