/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import org.openstreetmap.josm.Main;

public final class NTV2Util {
    private NTV2Util() {
    }

    public static final int getIntLE(byte[] byArray, int n) {
        return byArray[n++] & 0xFF | byArray[n++] << 8 & 0xFF00 | byArray[n++] << 16 & 0xFF0000 | byArray[n] << 24;
    }

    public static final int getIntBE(byte[] byArray, int n) {
        return byArray[n++] << 24 | byArray[n++] << 16 & 0xFF0000 | byArray[n++] << 8 & 0xFF00 | byArray[n] & 0xFF;
    }

    public static final int getInt(byte[] byArray, boolean bl) {
        if (bl) {
            return NTV2Util.getIntBE(byArray, 0);
        }
        return NTV2Util.getIntLE(byArray, 0);
    }

    public static final float getFloat(byte[] byArray, boolean bl) {
        int n = 0;
        n = bl ? NTV2Util.getIntBE(byArray, 0) : NTV2Util.getIntLE(byArray, 0);
        return Float.intBitsToFloat(n);
    }

    public static final double getDouble(byte[] byArray, boolean bl) {
        int n = 0;
        int n2 = 0;
        if (bl) {
            n = NTV2Util.getIntBE(byArray, 0);
            n2 = NTV2Util.getIntBE(byArray, 4);
        } else {
            n = NTV2Util.getIntLE(byArray, 4);
            n2 = NTV2Util.getIntLE(byArray, 0);
        }
        long l = (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }

    public static boolean isNioAvailable() {
        boolean bl = false;
        try {
            Class.forName("java.nio.channels.FileChannel");
            bl = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            Main.info(throwable.getMessage());
        }
        return bl;
    }
}

