/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.CustomProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.data.projection.datum.WGS84Datum;
import org.openstreetmap.josm.data.projection.proj.ClassProjFactory;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.data.projection.proj.LonLat;
import org.openstreetmap.josm.data.projection.proj.Mercator;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjFactory;
import org.openstreetmap.josm.data.projection.proj.SwissObliqueMercator;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.Pair;

public final class Projections {
    public static final Map<String, ProjFactory> projs = new HashMap<String, ProjFactory>();
    public static final Map<String, Ellipsoid> ellipsoids = new HashMap<String, Ellipsoid>();
    public static final Map<String, Datum> datums = new HashMap<String, Datum>();
    public static final Map<String, NTV2GridShiftFileWrapper> nadgrids = new HashMap<String, NTV2GridShiftFileWrapper>();
    public static final Map<String, Pair<String, String>> inits = new HashMap<String, Pair<String, String>>();
    private static final Set<String> allCodes;
    private static final Map<String, ProjectionChoice> allProjectionChoicesByCode;
    private static final Map<String, Projection> projectionsByCode_cache;

    private Projections() {
    }

    public static EastNorth project(LatLon latLon) {
        if (latLon == null) {
            return null;
        }
        return Main.getProjection().latlon2eastNorth(latLon);
    }

    public static LatLon inverseProject(EastNorth eastNorth) {
        if (eastNorth == null) {
            return null;
        }
        return Main.getProjection().eastNorth2latlon(eastNorth);
    }

    public static void registerBaseProjection(String string, ProjFactory projFactory, String string2) {
        projs.put(string, projFactory);
    }

    public static void registerBaseProjection(String string, Class<? extends Proj> clazz, String string2) {
        Projections.registerBaseProjection(string, new ClassProjFactory(clazz), string2);
    }

    public static Proj getBaseProjection(String string) {
        ProjFactory projFactory = projs.get(string);
        if (projFactory == null) {
            return null;
        }
        return projFactory.createInstance();
    }

    public static Ellipsoid getEllipsoid(String string) {
        return ellipsoids.get(string);
    }

    public static Datum getDatum(String string) {
        return datums.get(string);
    }

    public static NTV2GridShiftFileWrapper getNTV2Grid(String string) {
        return nadgrids.get(string);
    }

    public static String getInit(String string) {
        return (String)Projections.inits.get((Object)string.toUpperCase()).b;
    }

    private static void loadInits() {
        Pattern pattern = Pattern.compile("<(\\d+)>(.*)<>");
        try (InputStream inputStream = new CachedFile("resource://data/projection/epsg").getInputStream();
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String string;
            String string2 = "";
            while ((string = bufferedReader.readLine()) != null) {
                if (!(string = string.trim()).startsWith("#") && !string.isEmpty()) {
                    if (!string2.startsWith("#")) {
                        throw new AssertionError((Object)"EPSG file seems corrupted");
                    }
                    String string3 = string2.substring(1).trim();
                    Matcher matcher = pattern.matcher(string);
                    if (matcher.matches()) {
                        inits.put("EPSG:" + matcher.group(1), Pair.create(string3, matcher.group(2).trim()));
                    } else {
                        Main.warn("Failed to parse line from the EPSG projection definition: " + string);
                    }
                }
                string2 = string;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static Projection getProjectionByCode(String string) {
        String string2;
        Pair<String, String> pair;
        Projection projection = projectionsByCode_cache.get(string);
        if (projection != null) {
            return projection;
        }
        ProjectionChoice projectionChoice = allProjectionChoicesByCode.get(string);
        if (projectionChoice != null) {
            pair = projectionChoice.getPreferencesFromCode(string);
            projectionChoice.setPreferences((Collection<String>)((Object)pair));
            try {
                projection = projectionChoice.getProjection();
            }
            catch (Exception exception) {
                string2 = exception.getMessage();
                Main.warn("Unable to get projection " + string + " with " + projectionChoice + (string2 != null ? ". " + string2 : ""));
            }
        }
        if (projection == null) {
            pair = inits.get(string);
            if (pair == null) {
                return null;
            }
            String string3 = (String)pair.a;
            string2 = (String)pair.b;
            projection = new CustomProjection(string3, string, string2, null);
        }
        projectionsByCode_cache.put(string, projection);
        return projection;
    }

    public static Collection<String> getAllProjectionCodes() {
        return Collections.unmodifiableCollection(allCodes);
    }

    static {
        Projections.registerBaseProjection("lonlat", LonLat.class, "core");
        Projections.registerBaseProjection("josm:smerc", Mercator.class, "core");
        Projections.registerBaseProjection("lcc", LambertConformalConic.class, "core");
        Projections.registerBaseProjection("somerc", SwissObliqueMercator.class, "core");
        Projections.registerBaseProjection("tmerc", TransverseMercator.class, "core");
        ellipsoids.put("clarkeIGN", Ellipsoid.clarkeIGN);
        ellipsoids.put("intl", Ellipsoid.hayford);
        ellipsoids.put("GRS67", Ellipsoid.GRS67);
        ellipsoids.put("GRS80", Ellipsoid.GRS80);
        ellipsoids.put("WGS84", Ellipsoid.WGS84);
        ellipsoids.put("bessel", Ellipsoid.Bessel1841);
        datums.put("WGS84", WGS84Datum.INSTANCE);
        nadgrids.put("BETA2007.gsb", NTV2GridShiftFileWrapper.BETA2007);
        nadgrids.put("ntf_r93_b.gsb", NTV2GridShiftFileWrapper.ntf_rgf93);
        Projections.loadInits();
        allCodes = new HashSet<String>();
        allProjectionChoicesByCode = new HashMap<String, ProjectionChoice>();
        projectionsByCode_cache = new HashMap<String, Projection>();
        for (ProjectionChoice projectionChoice : ProjectionPreference.getProjectionChoices()) {
            for (String string : projectionChoice.allCodes()) {
                allProjectionChoicesByCode.put(string, projectionChoice);
            }
        }
        allCodes.addAll(inits.keySet());
        allCodes.addAll(allProjectionChoicesByCode.keySet());
    }
}

