/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class HistoryRelation
extends HistoryOsmPrimitive {
    private List<RelationMemberData> members = new ArrayList<RelationMemberData>();

    public HistoryRelation(long l, long l2, boolean bl, User user, long l3, Date date) throws IllegalArgumentException {
        super(l, l2, bl, user, l3, date);
    }

    public HistoryRelation(long l, long l2, boolean bl, User user, long l3, Date date, boolean bl2) throws IllegalArgumentException {
        super(l, l2, bl, user, l3, date, bl2);
    }

    public HistoryRelation(long l, long l2, boolean bl, User user, long l3, Date date, List<RelationMemberData> list) {
        this(l, l2, bl, user, l3, date);
        if (list != null) {
            this.members.addAll(list);
        }
    }

    public HistoryRelation(Relation relation) {
        super(relation);
    }

    public List<RelationMemberData> getMembers() {
        return Collections.unmodifiableList(this.members);
    }

    public int getNumMembers() {
        return this.members.size();
    }

    public RelationMemberData getRelationMember(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.members.size()) {
            throw new IndexOutOfBoundsException(MessageFormat.format("Parameter {0} not in range 0..{1}. Got ''{2}''.", "idx", this.members.size(), n));
        }
        return this.members.get(n);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.RELATION;
    }

    public void addMember(RelationMemberData relationMemberData) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(relationMemberData, "member");
        this.members.add(relationMemberData);
    }

    @Override
    public String getDisplayName(HistoryNameFormatter historyNameFormatter) {
        return historyNameFormatter.format(this);
    }
}

