/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public final class Node
extends OsmPrimitive
implements INode {
    private double lat = Double.NaN;
    private double lon = Double.NaN;
    private double east = Double.NaN;
    private double north = Double.NaN;

    private boolean isLatLonKnown() {
        return !Double.isNaN(this.lat) && !Double.isNaN(this.lon);
    }

    @Override
    public final void setCoor(LatLon latLon) {
        this.updateCoor(latLon, null);
    }

    @Override
    public final void setEastNorth(EastNorth eastNorth) {
        this.updateCoor(null, eastNorth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCoor(LatLon latLon, EastNorth eastNorth) {
        if (this.getDataSet() != null) {
            boolean bl = this.writeLock();
            try {
                this.getDataSet().fireNodeMoved(this, latLon, eastNorth);
            }
            finally {
                this.writeUnlock(bl);
            }
        } else {
            this.setCoorInternal(latLon, eastNorth);
        }
    }

    @Override
    public final LatLon getCoor() {
        if (!this.isLatLonKnown()) {
            return null;
        }
        return new LatLon(this.lat, this.lon);
    }

    @Override
    public final EastNorth getEastNorth() {
        if (!this.isLatLonKnown()) {
            return null;
        }
        if (this.getDataSet() == null) {
            return Projections.project(new LatLon(this.lat, this.lon));
        }
        if (Double.isNaN(this.east) || Double.isNaN(this.north)) {
            EastNorth eastNorth = Projections.project(new LatLon(this.lat, this.lon));
            this.east = eastNorth.east();
            this.north = eastNorth.north();
        }
        return new EastNorth(this.east, this.north);
    }

    protected void setCoorInternal(LatLon latLon, EastNorth eastNorth) {
        if (latLon != null) {
            this.lat = latLon.lat();
            this.lon = latLon.lon();
            this.invalidateEastNorthCache();
        } else if (eastNorth != null) {
            LatLon latLon2 = Projections.inverseProject(eastNorth);
            this.lat = latLon2.lat();
            this.lon = latLon2.lon();
            this.east = eastNorth.east();
            this.north = eastNorth.north();
        } else {
            this.lat = Double.NaN;
            this.lon = Double.NaN;
            this.invalidateEastNorthCache();
            if (this.isVisible()) {
                this.setIncomplete(true);
            }
        }
    }

    protected Node(long l, boolean bl) {
        super(l, bl);
    }

    public Node() {
        this(0L, false);
    }

    public Node(long l) throws IllegalArgumentException {
        super(l, false);
    }

    public Node(long l, int n) throws IllegalArgumentException {
        super(l, n, false);
    }

    public Node(Node node, boolean bl) {
        super(node.getUniqueId(), true);
        this.cloneFrom(node);
        if (bl) {
            this.clearOsmMetadata();
        }
    }

    public Node(Node node) {
        this(node, false);
    }

    public Node(LatLon latLon) {
        super(0L, false);
        this.setCoor(latLon);
    }

    public Node(EastNorth eastNorth) {
        super(0L, false);
        this.setEastNorth(eastNorth);
    }

    @Override
    void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        if (!this.isIncomplete() && this.isVisible() && (this.getCoor() == null || this.getEastNorth() == null)) {
            throw new DataIntegrityProblemException("Complete node with null coordinates: " + this.toString());
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(PrimitiveVisitor primitiveVisitor) {
        primitiveVisitor.visit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloneFrom(OsmPrimitive osmPrimitive) {
        boolean bl = this.writeLock();
        try {
            super.cloneFrom(osmPrimitive);
            this.setCoor(((Node)osmPrimitive).getCoor());
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeFrom(OsmPrimitive osmPrimitive) {
        boolean bl = this.writeLock();
        try {
            super.mergeFrom(osmPrimitive);
            if (!osmPrimitive.isIncomplete()) {
                this.setCoor(((Node)osmPrimitive).getCoor());
            }
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(PrimitiveData primitiveData) {
        boolean bl = this.writeLock();
        try {
            super.load(primitiveData);
            this.setCoor(((NodeData)primitiveData).getCoor());
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public NodeData save() {
        NodeData nodeData = new NodeData();
        this.saveCommonAttributes(nodeData);
        if (!this.isIncomplete()) {
            nodeData.setCoor(this.getCoor());
        }
        return nodeData;
    }

    public String toString() {
        String string = this.isLatLonKnown() ? "lat=" + this.lat + ",lon=" + this.lon : "";
        return "{Node id=" + this.getUniqueId() + " version=" + this.getVersion() + " " + this.getFlagsAsString() + " " + string + "}";
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (!(osmPrimitive instanceof Node)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive)) {
            return false;
        }
        Node node = (Node)osmPrimitive;
        LatLon latLon = this.getCoor();
        LatLon latLon2 = node.getCoor();
        if (latLon == null && latLon2 == null) {
            return true;
        }
        if (latLon != null && latLon2 != null) {
            return latLon.equalsEpsilon(latLon2);
        }
        return false;
    }

    @Override
    public int compareTo(OsmPrimitive osmPrimitive) {
        return osmPrimitive instanceof Node ? Long.valueOf(this.getUniqueId()).compareTo(osmPrimitive.getUniqueId()) : 1;
    }

    @Override
    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.NODE;
    }

    @Override
    public BBox getBBox() {
        return new BBox(this);
    }

    @Override
    public void updatePosition() {
    }

    @Override
    public boolean isDrawable() {
        return super.isDrawable() && this.isLatLonKnown();
    }

    public boolean isConnectionNode() {
        return this.isReferredByWays(2);
    }

    public void invalidateEastNorthCache() {
        this.east = Double.NaN;
        this.north = Double.NaN;
    }

    @Override
    public boolean concernsArea() {
        return false;
    }

    public boolean isConnectedTo(Collection<Node> collection, int n, Predicate<Node> predicate) {
        CheckParameterUtil.ensureParameterNotNull(collection);
        CheckParameterUtil.ensureThat(!collection.isEmpty(), "otherNodes must not be empty!");
        CheckParameterUtil.ensureThat(n >= 0, "hops must be non-negative!");
        return n == 0 ? this.isConnectedTo(collection, n, predicate, null) : this.isConnectedTo(collection, n, predicate, new TreeSet<Node>());
    }

    private boolean isConnectedTo(Collection<Node> collection, int n, Predicate<Node> predicate, Set<Node> set) {
        if (collection.contains(this)) {
            return true;
        }
        if (n > 0) {
            set.add(this);
            for (Way way : Utils.filteredCollection(this.getReferrers(), Way.class)) {
                for (Node node : way.getNodes()) {
                    boolean bl = set.contains(node);
                    set.add(node);
                    if (bl || predicate != null && !predicate.evaluate(node) || !node.isConnectedTo(collection, n - 1, predicate, set)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isOutsideDownloadArea() {
        return !this.isNewOrUndeleted() && this.getDataSet() != null && this.getDataSet().getDataSourceArea() != null && !this.getCoor().isIn(this.getDataSet().getDataSourceArea());
    }
}

