/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.tools.I18n;

public class FixDataHook
implements UploadHook {
    private List<FixData> deprecated = new LinkedList<FixData>();

    public FixDataHook() {
        this.deprecated.add(new FixDataSpace());
        this.deprecated.add(new FixDataKey("color", "colour"));
        this.deprecated.add(new FixDataTag("highway", "ford", "ford", "yes"));
        this.deprecated.add(new FixDataTag("oneway", "false", "oneway", "no"));
        this.deprecated.add(new FixDataTag("oneway", "0", "oneway", "no"));
        this.deprecated.add(new FixDataTag("oneway", "true", "oneway", "yes"));
        this.deprecated.add(new FixDataTag("oneway", "1", "oneway", "yes"));
        this.deprecated.add(new FixDataTag("highway", "stile", "barrier", "stile"));
        this.deprecated.add(new FixData(){

            @Override
            public boolean fixKeys(Map<String, String> map, OsmPrimitive osmPrimitive) {
                if (osmPrimitive instanceof Relation && "multipolygon".equals(map.get("type")) && "administrative".equals(map.get("boundary"))) {
                    map.put("type", "boundary");
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public boolean checkUpload(APIDataSet aPIDataSet) {
        if (!Main.pref.getBoolean("fix.data.on.upload", true)) {
            return true;
        }
        List<OsmPrimitive> list = aPIDataSet.getPrimitives();
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (OsmPrimitive osmPrimitive : list) {
            Map<String, String> map = osmPrimitive.getKeys();
            if (map.isEmpty()) continue;
            boolean bl = false;
            for (FixData fixData : this.deprecated) {
                if (!fixData.fixKeys(map, osmPrimitive)) continue;
                bl = true;
            }
            if (!bl) continue;
            linkedList.add(new ChangePropertyCommand(Collections.singleton(osmPrimitive), new HashMap<String, String>(map)));
        }
        if (!linkedList.isEmpty()) {
            Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Fix deprecated tags", new Object[0]), linkedList));
        }
        return true;
    }

    public static class FixDataTag
    implements FixData {
        String oldKey;
        String oldValue;
        String newKey;
        String newValue;

        public FixDataTag(String string, String string2, String string3, String string4) {
            this.oldKey = string;
            this.oldValue = string2;
            this.newKey = string3;
            this.newValue = string4;
        }

        @Override
        public boolean fixKeys(Map<String, String> map, OsmPrimitive osmPrimitive) {
            if (this.oldValue.equals(map.get(this.oldKey)) && (this.newKey.equals(this.oldKey) || !map.containsKey(this.newKey))) {
                map.put(this.newKey, this.newValue);
                if (!this.newKey.equals(this.oldKey)) {
                    map.remove(this.oldKey);
                }
                return true;
            }
            return false;
        }
    }

    public static class FixDataKey
    implements FixData {
        String oldKey;
        String newKey;

        public FixDataKey(String string, String string2) {
            this.oldKey = string;
            this.newKey = string2;
        }

        @Override
        public boolean fixKeys(Map<String, String> map, OsmPrimitive osmPrimitive) {
            if (map.containsKey(this.oldKey) && !map.containsKey(this.newKey)) {
                map.put(this.newKey, map.get(this.oldKey));
                map.remove(this.oldKey);
                return true;
            }
            return false;
        }
    }

    public static class FixDataSpace
    implements FixData {
        @Override
        public boolean fixKeys(Map<String, String> map, OsmPrimitive osmPrimitive) {
            boolean bl;
            HashMap<String, String> hashMap = new HashMap<String, String>(map);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = Tag.removeWhiteSpaces(entry.getValue());
                String string2 = Tag.removeWhiteSpaces(entry.getKey());
                if (!entry.getKey().equals(string2)) {
                    boolean bl2;
                    boolean bl3 = bl2 = string2.isEmpty() || string.isEmpty();
                    if (!bl2 && map.containsKey(string2)) continue;
                    hashMap.remove(entry.getKey());
                    if (bl2) continue;
                    hashMap.put(string2, string);
                    continue;
                }
                if (entry.getValue().equals(string)) continue;
                if (string.isEmpty()) {
                    hashMap.remove(string2);
                    continue;
                }
                hashMap.put(string2, string);
            }
            boolean bl4 = bl = !map.equals(hashMap);
            if (bl) {
                map.clear();
                map.putAll(hashMap);
            }
            return bl;
        }
    }

    public static interface FixData {
        public boolean fixKeys(Map<String, String> var1, OsmPrimitive var2);
    }
}

