/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.io.XmlWriter;

public abstract class AbstractDownloadTask
implements DownloadTask {
    private List<Object> errorMessages = new ArrayList<Object>();
    private boolean canceled = false;
    private boolean failed = false;

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean bl) {
        this.failed = bl;
    }

    protected void rememberErrorMessage(String string) {
        this.errorMessages.add(string);
    }

    protected void rememberException(Exception exception) {
        this.errorMessages.add(exception);
    }

    @Override
    public List<Object> getErrorObjects() {
        return this.errorMessages;
    }

    @Override
    public String acceptsDocumentationSummary() {
        StringBuilder stringBuilder = new StringBuilder("<tr><td>");
        stringBuilder.append(this.getTitle());
        stringBuilder.append(":</td><td>");
        String[] stringArray = this.getPatterns();
        if (stringArray.length > 0) {
            stringBuilder.append("<ul>");
            for (String string : stringArray) {
                stringBuilder.append("<li>");
                stringBuilder.append(XmlWriter.encode(string));
                stringBuilder.append("</li>");
            }
            stringBuilder.append("</ul>");
        }
        stringBuilder.append("</td></tr>");
        return stringBuilder.toString();
    }

    @Override
    public boolean acceptsUrl(String string) {
        if (string == null) {
            return false;
        }
        for (String string2 : this.getPatterns()) {
            if (!string.matches(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return this.getClass().getName();
    }

    @Override
    public String[] getPatterns() {
        return new String[0];
    }
}

