/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ReportBugAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public final class ShowStatusReportAction
extends JosmAction {
    public ShowStatusReportAction() {
        super(I18n.tr("Show Status Report", new Object[0]), "clock", I18n.tr("Show status report with useful information that can be attached to bugs", new Object[0]), Shortcut.registerShortcut("help:showstatusreport", I18n.tr("Help: {0}", I18n.tr("Show Status Report", new Object[0])), 65535, 5000), false);
        this.putValue("help", HelpUtil.ht("/Action/ShowStatusReport"));
        this.putValue("toolbar", "help/showstatusreport");
        Main.toolbar.register(this);
    }

    private static void shortenParam(ListIterator<String> listIterator, String[] stringArray, String string, String string2) {
        if (string != null && string2.length() < string.length() && stringArray[1].startsWith(string)) {
            listIterator.set(stringArray[0] + "=" + stringArray[1].replace(string, string2));
        }
    }

    public static String getReportHeader() {
        String string;
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Version.getInstance().getReleaseAttributes());
        stringBuilder.append("\n");
        stringBuilder.append("Identification: " + Version.getInstance().getAgentString());
        stringBuilder.append("\n");
        stringBuilder.append("Memory Usage: ");
        stringBuilder.append(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        stringBuilder.append(" MB / ");
        stringBuilder.append(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        stringBuilder.append(" MB (");
        stringBuilder.append(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        stringBuilder.append(" MB allocated, but free)");
        stringBuilder.append("\n");
        stringBuilder.append("Java version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor") + ", " + System.getProperty("java.vm.name"));
        stringBuilder.append("\n");
        if (Main.platform.getClass() == PlatformHookUnixoid.class) {
            object2 = ((PlatformHookUnixoid)Main.platform).getJavaPackageDetails();
            if (object2 != null) {
                stringBuilder.append("Java package: ");
                stringBuilder.append((String)object2);
                stringBuilder.append("\n");
            }
            if (Package.getPackage("javax.jnlp") != null && (object = ((PlatformHookUnixoid)Main.platform).getWebStartPackageDetails()) != null) {
                stringBuilder.append("WebStart package: ");
                stringBuilder.append((String)object);
                stringBuilder.append("\n");
            }
        }
        try {
            object2 = System.getenv("JAVA_HOME");
            object = Main.isPlatformWindows() ? "%JAVA_HOME%" : "${JAVA_HOME}";
            string = System.getProperty("java.home");
            ArrayList<String> arrayList = new ArrayList<String>(ManagementFactory.getRuntimeMXBean().getInputArguments());
            ListIterator<String> listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                String string2 = (String)listIterator.next();
                if (string2.contains("=")) {
                    String[] stringArray = string2.split("=");
                    if (stringArray[0].toLowerCase().startsWith("-dproxy")) {
                        listIterator.set(stringArray[0] + "=xxx");
                        continue;
                    }
                    ShowStatusReportAction.shortenParam(listIterator, stringArray, object2, (String)object);
                    ShowStatusReportAction.shortenParam(listIterator, stringArray, string, "<java.home>");
                    continue;
                }
                if (!string2.startsWith("-X")) continue;
                listIterator.remove();
            }
            if (!arrayList.isEmpty()) {
                stringBuilder.append("VM arguments: " + ((Object)arrayList).toString().replace("\\\\", "\\"));
                stringBuilder.append("\n");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (Main.commandLineArgs.length > 0) {
            stringBuilder.append("Program arguments: " + Arrays.toString(Main.commandLineArgs));
            stringBuilder.append("\n");
        }
        if (Main.main != null && (object2 = Main.main.getCurrentDataSet()) != null) {
            object = DatasetConsistencyTest.runTests((DataSet)object2);
            if (((String)object).length() == 0) {
                stringBuilder.append("Dataset consistency test: No problems found\n");
            } else {
                stringBuilder.append("\nDataset consistency test:\n" + (String)object + "\n");
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append(PluginHandler.getBugReportText());
        stringBuilder.append("\n");
        object2 = Main.getLastErrorAndWarnings();
        if (!object2.isEmpty()) {
            stringBuilder.append("Last errors/warnings:\n");
            object = object2.iterator();
            while (object.hasNext()) {
                string = (String)object.next();
                stringBuilder.append("- ").append(string).append("\n");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        String string = ShowStatusReportAction.getReportHeader();
        stringBuilder.append(string);
        try {
            object = Main.pref.getAllSettings();
            serializable = new HashSet<String>(object.keySet());
            for (String object2 : serializable) {
                if (!object2.startsWith("marker.show") && !object2.contains("username") && !object2.contains("password") && !object2.contains("access-token")) continue;
                object.remove(object2);
            }
            for (Map.Entry entry : object.entrySet()) {
                stringBuilder.append((String)entry.getKey()).append("=").append(((Preferences.Setting)entry.getValue()).getValue().toString()).append("\n");
            }
        }
        catch (Exception exception) {
            Main.error(exception);
        }
        object = new JosmTextArea(stringBuilder.toString());
        ((JTextArea)object).setWrapStyleWord(true);
        ((JTextArea)object).setLineWrap(true);
        ((JTextComponent)object).setEditable(false);
        serializable = new JScrollPane((Component)object);
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Status Report", new Object[0]), new String[]{I18n.tr("Copy to clipboard and close", new Object[0]), I18n.tr("Report bug", new Object[0]), I18n.tr("Close", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"copy.png", "bug.png", "cancel.png"});
        extendedDialog.setContent((Component)serializable, false);
        extendedDialog.setMinimumSize(new Dimension(380, 200));
        extendedDialog.setPreferredSize(new Dimension(700, Main.parent.getHeight() - 50));
        switch (extendedDialog.showDialog().getValue()) {
            case 1: {
                Utils.copyToClipboard(stringBuilder.toString());
                break;
            }
            case 2: {
                ReportBugAction.reportBug(string);
            }
        }
    }
}

