/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

public class JumpToAction
extends JosmAction {
    private final JosmTextField url = new JosmTextField();
    private final JosmTextField lat = new JosmTextField();
    private final JosmTextField lon = new JosmTextField();
    private final JosmTextField zm = new JosmTextField();

    public JumpToAction() {
        super(I18n.tr("Jump To Position", new Object[0]), (Icon)null, I18n.tr("Opens a dialog that allows to jump to a specific location", new Object[0]), Shortcut.registerShortcut("tools:jumpto", I18n.tr("Tool: {0}", I18n.tr("Jump To Position", new Object[0])), 74, 5006), true, "action/jumpto", true);
    }

    public void showJumpToDialog() {
        if (!Main.isDisplayingMapView()) {
            return;
        }
        MapView mapView = Main.map.mapView;
        LatLon latLon = mapView.getProjection().eastNorth2latlon(mapView.getCenter());
        this.lat.setText(Double.toString(latLon.lat()));
        this.lon.setText(Double.toString(latLon.lon()));
        double d = mapView.getDist100Pixel();
        double d2 = 1.0 / d;
        this.zm.setText(Long.toString(Math.round(d * 100.0) / 100L));
        this.updateUrl(true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("<html>" + I18n.tr("Enter Lat/Lon to jump to position.", new Object[0]) + "<br>" + I18n.tr("You can also paste an URL from www.openstreetmap.org", new Object[0]) + "<br>" + "</html>"), "North");
        OsmLonLatListener osmLonLatListener = new OsmLonLatListener();
        this.lat.getDocument().addDocumentListener(osmLonLatListener);
        this.lon.getDocument().addDocumentListener(osmLonLatListener);
        this.zm.getDocument().addDocumentListener(osmLonLatListener);
        this.url.getDocument().addDocumentListener(new OsmURLListener());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel2.add((Component)new JLabel(I18n.tr("Latitude", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.lat, GBC.eol().fill(2));
        jPanel2.add((Component)new JLabel(I18n.tr("Longitude", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.lon, GBC.eol().fill(2));
        jPanel2.add((Component)new JLabel(I18n.tr("Zoom (in metres)", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.zm, GBC.eol().fill(2));
        jPanel2.add((Component)new JLabel(I18n.tr("URL", new Object[0])), GBC.eol());
        jPanel2.add((Component)this.url, GBC.eol().fill(2));
        Object[] objectArray = new Object[]{I18n.tr("Jump there", new Object[0]), I18n.tr("Cancel", new Object[0])};
        LatLon latLon2 = null;
        double d3 = 100.0;
        while (latLon2 == null) {
            int n = JOptionPane.showOptionDialog(Main.parent, jPanel, I18n.tr("Jump to Position", new Object[0]), 2, -1, null, objectArray, objectArray[0]);
            if (n != 0) {
                return;
            }
            try {
                d3 = Double.parseDouble(this.zm.getText());
                latLon2 = new LatLon(Double.parseDouble(this.lat.getText()), Double.parseDouble(this.lon.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not parse Latitude, Longitude or Zoom. Please check.", new Object[0]), I18n.tr("Unable to parse Lon/Lat", new Object[0]), 0);
            }
        }
        mapView.zoomToFactor(mapView.getProjection().latlon2eastNorth(latLon2), d2 * d3);
    }

    private void parseURL() {
        if (!this.url.hasFocus()) {
            return;
        }
        String string = this.url.getText();
        Bounds bounds = OsmUrlToBounds.parse(string);
        if (bounds != null) {
            this.lat.setText(Double.toString((bounds.getMinLat() + bounds.getMaxLat()) / 2.0));
            this.lon.setText(Double.toString((bounds.getMinLon() + bounds.getMaxLon()) / 2.0));
            int n = 16;
            int n2 = string.indexOf("#map");
            if (n2 >= 0) {
                n = Integer.parseInt(string.substring(n2 + 5, string.indexOf(47, n2)));
            } else {
                String[] stringArray;
                for (String string2 : stringArray = string.substring(string.indexOf(63) + 1).split("&")) {
                    int n3 = string2.indexOf(61);
                    if (n3 == -1 || !"zoom".equalsIgnoreCase(string2.substring(0, n3))) continue;
                    n = Integer.parseInt(string2.substring(n3 + 1));
                    break;
                }
            }
            this.zm.setText(Double.toString(Math.round(1.0E7 * Math.pow(2.0, -1 * n))));
        }
    }

    private void updateUrl(boolean bl) {
        if (!(this.lat.hasFocus() || this.lon.hasFocus() || this.zm.hasFocus() || bl)) {
            return;
        }
        try {
            double d = Double.parseDouble(this.lat.getText());
            double d2 = Double.parseDouble(this.lon.getText());
            double d3 = Double.parseDouble(this.zm.getText());
            int n = 18;
            if (d3 > 0.0) {
                n = (int)Math.round(-1.0 * Math.log(d3 / 1.0E7) / Math.log(2.0));
            }
            this.url.setText(OsmUrlToBounds.getURL(d, d2, n));
        }
        catch (NumberFormatException numberFormatException) {
            Main.debug(numberFormatException.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.showJumpToDialog();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(Main.isDisplayingMapView());
    }

    @Override
    protected void installAdapters() {
        super.installAdapters();
        Main.addMapFrameListener(new MapFrameListener(){

            @Override
            public void mapFrameInitialized(MapFrame mapFrame, MapFrame mapFrame2) {
                JumpToAction.this.updateEnabledState();
            }
        });
    }

    class OsmLonLatListener
    implements DocumentListener {
        OsmLonLatListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.updateUrl(false);
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.updateUrl(false);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.updateUrl(false);
        }
    }

    class OsmURLListener
    implements DocumentListener {
        OsmURLListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.parseURL();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.parseURL();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JumpToAction.this.parseURL();
        }
    }
}

