/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.SelectCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class FollowLineAction
extends JosmAction {
    public FollowLineAction() {
        super(I18n.tr("Follow line", new Object[0]), "followline.png", I18n.tr("Continues drawing a line that shares nodes with another line.", new Object[0]), Shortcut.registerShortcut("tools:followline", I18n.tr("Tool: {0}", I18n.tr("Follow", new Object[0])), 70, 5003), true);
    }

    @Override
    protected void updateEnabledState() {
        if (FollowLineAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(FollowLineAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        List<OsmPrimitive> list;
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        if (osmDataLayer == null) {
            return;
        }
        if (!(Main.map.mapMode instanceof DrawAction)) {
            return;
        }
        Collection<Node> collection = osmDataLayer.data.getSelectedNodes();
        Collection<Way> collection2 = osmDataLayer.data.getSelectedWays();
        if (collection.size() > 1 || collection2.size() != 1) {
            return;
        }
        Node node = ((DrawAction)Main.map.mapMode).getCurrentBaseNode();
        if (node == null) {
            return;
        }
        Way way = collection2.iterator().next();
        if (way.isClosed()) {
            return;
        }
        Node node2 = way.getNode(1);
        boolean bl = true;
        if (way.lastNode().equals(node)) {
            node2 = way.getNode(way.getNodesCount() - 2);
            bl = false;
        }
        if ((list = node.getReferrers()).size() < 2) {
            return;
        }
        Node node3 = null;
        for (Way way2 : Utils.filteredCollection(list, Way.class)) {
            if (way2.equals(way)) continue;
            Set<Node> set = way2.getNeighbours(node);
            set.remove(node2);
            if (set.isEmpty()) continue;
            if (set.size() > 1) {
                return;
            }
            Node node4 = set.iterator().next();
            if (node3 != null && node3 != node4) {
                return;
            }
            node3 = node4;
        }
        if (node3 != null) {
            Way way3 = new Way(way);
            if (bl) {
                way3.addNode(0, node3);
            } else {
                way3.addNode(node3);
            }
            Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Follow line", new Object[0]), new ChangeCommand(way, way3), new SelectCommand(way3.isClosed() ? Arrays.asList(way3) : Arrays.asList(way3, node3))));
            if (Main.map.mapView.viewportFollowing) {
                Main.map.mapView.smoothScrollTo(node3.getEastNorth());
            }
        }
    }
}

