/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ToggleAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DialogsToggleAction
extends ToggleAction {
    public DialogsToggleAction() {
        super(I18n.tr("Toggle dialogs panel", new Object[0]), (Icon)null, I18n.tr("Toggle dialogs panel, maximize mapview", new Object[0]), Shortcut.registerShortcut("menu:view:dialogspanel", I18n.tr("Toggle dialogs panel", new Object[0]), 9, 5003), true, "dialogspanel", false);
        this.putValue("help", HelpUtil.ht("/Action/ToggleDialogsPanel"));
        this.setSelected(Main.pref.getBoolean("draw.dialogspanel", true));
        this.notifySelectedState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.toggleSelectedState(actionEvent);
        Main.pref.put("draw.dialogspanel", this.isSelected());
        this.notifySelectedState();
        this.setMode();
    }

    public void initial() {
        if (this.isSelected()) {
            this.setMode();
        }
    }

    protected void setMode() {
        if (Main.isDisplayingMapView()) {
            boolean bl = this.isSelected();
            Main.map.setDialogsPanelVisible(bl);
            Main.map.statusLine.setVisible(bl || Main.pref.getBoolean("statusbar.always-visible", true));
            Main.toolbar.control.setVisible(bl || Main.pref.getBoolean("toolbar.always-visible", true));
            Main.main.menu.setVisible(bl || Main.pref.getBoolean("menu.always-visible", true));
            if (!Main.pref.getBoolean("sidetoolbar.always-visible", true)) {
                Main.pref.put("sidetoolbar.visible", bl);
            }
            Main.map.mapView.rememberLastPositionOnScreen();
        }
    }
}

