/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

public class OsmMercator {
    public static int TILE_SIZE = 256;
    public static final double MAX_LAT = 85.05112877980659;
    public static final double MIN_LAT = -85.05112877980659;
    private static double EARTH_RADIUS = 6378137.0;

    public static double radius(int n) {
        return (double)(TILE_SIZE * (1 << n)) / (Math.PI * 2);
    }

    public static int getMaxPixels(int n) {
        return TILE_SIZE * (1 << n);
    }

    public static int falseEasting(int n) {
        return OsmMercator.getMaxPixels(n) / 2;
    }

    public static int falseNorthing(int n) {
        return -1 * OsmMercator.getMaxPixels(n) / 2;
    }

    public static double getDistance(int n, int n2, int n3, int n4, int n5) {
        double d = OsmMercator.YToLat(n2, n5);
        double d2 = OsmMercator.XToLon(n, n5);
        double d3 = OsmMercator.YToLat(n4, n5);
        double d4 = OsmMercator.XToLon(n3, n5);
        return OsmMercator.getDistance(d, d2, d3, d4);
    }

    public static double getDistance(double d, double d2, double d3, double d4) {
        double d5 = Math.toRadians(d);
        double d6 = Math.toRadians(d2);
        double d7 = Math.toRadians(d3);
        double d8 = Math.toRadians(d4);
        double d9 = Math.acos(Math.sin(d5) * Math.sin(d7) + Math.cos(d5) * Math.cos(d7) * Math.cos(d8 - d6));
        return EARTH_RADIUS * d9;
    }

    public static double LonToX(double d, int n) {
        int n2 = OsmMercator.getMaxPixels(n);
        double d2 = (double)n2 * (d + 180.0) / 360.0;
        return Math.min(d2, (double)(n2 - 1));
    }

    public static double LatToY(double d, int n) {
        if (d < -85.05112877980659) {
            d = -85.05112877980659;
        } else if (d > 85.05112877980659) {
            d = 85.05112877980659;
        }
        double d2 = Math.sin(Math.toRadians(d));
        double d3 = Math.log((1.0 + d2) / (1.0 - d2));
        int n2 = OsmMercator.getMaxPixels(n);
        double d4 = (double)n2 * (0.5 - d3 / (Math.PI * 4));
        return Math.min(d4, (double)(n2 - 1));
    }

    public static double XToLon(int n, int n2) {
        return 360.0 * (double)n / (double)OsmMercator.getMaxPixels(n2) - 180.0;
    }

    public static double YToLat(int n, int n2) {
        double d = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-1.0 * (double)(n += OsmMercator.falseNorthing(n2)) / OsmMercator.radius(n2)));
        return -1.0 * Math.toDegrees(d);
    }
}

