/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.MapObjectImpl;
import org.openstreetmap.gui.jmapviewer.Style;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;

public class MapMarkerCircle
extends MapObjectImpl
implements MapMarker {
    Coordinate coord;
    double radius;
    MapMarker.STYLE markerStyle;

    public MapMarkerCircle(Coordinate coordinate, double d) {
        this(null, null, coordinate, d);
    }

    public MapMarkerCircle(String string, Coordinate coordinate, double d) {
        this(null, string, coordinate, d);
    }

    public MapMarkerCircle(Layer layer, Coordinate coordinate, double d) {
        this(layer, null, coordinate, d);
    }

    public MapMarkerCircle(double d, double d2, double d3) {
        this(null, null, new Coordinate(d, d2), d3);
    }

    public MapMarkerCircle(Layer layer, double d, double d2, double d3) {
        this(layer, null, new Coordinate(d, d2), d3);
    }

    public MapMarkerCircle(Layer layer, String string, Coordinate coordinate, double d) {
        this(layer, string, coordinate, d, MapMarker.STYLE.VARIABLE, MapMarkerCircle.getDefaultStyle());
    }

    public MapMarkerCircle(Layer layer, String string, Coordinate coordinate, double d, MapMarker.STYLE sTYLE, Style style) {
        super(layer, string, style);
        this.markerStyle = sTYLE;
        this.coord = coordinate;
        this.radius = d;
    }

    @Override
    public Coordinate getCoordinate() {
        return this.coord;
    }

    @Override
    public double getLat() {
        return this.coord.getLat();
    }

    @Override
    public double getLon() {
        return this.coord.getLon();
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public MapMarker.STYLE getMarkerStyle() {
        return this.markerStyle;
    }

    @Override
    public void paint(Graphics graphics, Point point, int n) {
        int n2 = n;
        int n3 = n2 * 2;
        if (graphics instanceof Graphics2D && this.getBackColor() != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3));
            graphics2D.setPaint(this.getBackColor());
            graphics.fillOval(point.x - n2, point.y - n2, n3, n3);
            graphics2D.setComposite(composite);
        }
        graphics.setColor(this.getColor());
        graphics.drawOval(point.x - n2, point.y - n2, n3, n3);
        if (this.getLayer() == null || this.getLayer().isVisibleTexts().booleanValue()) {
            this.paintText(graphics, point);
        }
    }

    public static Style getDefaultStyle() {
        return new Style(Color.ORANGE, new Color(200, 200, 200, 200), null, MapMarkerCircle.getDefaultFont());
    }

    public String toString() {
        return "MapMarker at " + this.getLat() + " " + this.getLon();
    }

    @Override
    public void setLat(double d) {
        if (this.coord == null) {
            this.coord = new Coordinate(d, 0.0);
        } else {
            this.coord.setLat(d);
        }
    }

    @Override
    public void setLon(double d) {
        if (this.coord == null) {
            this.coord = new Coordinate(0.0, d);
        } else {
            this.coord.setLon(d);
        }
    }
}

