/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Gradient;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.batik.MultipleGradientPaint;
import com.kitfox.svg.batik.RadialGradientPaint;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class RadialGradient
extends Gradient {
    public static final String TAG_NAME = "radialgradient";
    float cx = 0.5f;
    float cy = 0.5f;
    float fx = 0.5f;
    float fy = 0.5f;
    float r = 0.5f;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("cx"))) {
            this.cx = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("cy"))) {
            this.cy = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("fx"))) {
            this.fx = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("fy"))) {
            this.fy = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("r"))) {
            this.r = styleAttribute.getFloatValueWithUnits();
        }
    }

    @Override
    public Paint getPaint(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        Paint paint;
        MultipleGradientPaint.CycleMethodEnum cycleMethodEnum;
        switch (this.spreadMethod) {
            default: {
                cycleMethodEnum = MultipleGradientPaint.NO_CYCLE;
                break;
            }
            case 1: {
                cycleMethodEnum = MultipleGradientPaint.REPEAT;
                break;
            }
            case 2: {
                cycleMethodEnum = MultipleGradientPaint.REFLECT;
            }
        }
        Point2D.Float float_ = new Point2D.Float(this.cx, this.cy);
        Point2D.Float float_2 = new Point2D.Float(this.fx, this.fy);
        if (float_.equals(float_2)) {
            Color[] colorArray = this.getStopColors();
            paint = colorArray.length > 0 ? colorArray[0] : Color.black;
        } else if (this.gradientUnits == 1) {
            paint = new RadialGradientPaint(float_, this.r, float_2, this.getStopFractions(), this.getStopColors(), cycleMethodEnum, MultipleGradientPaint.SRGB, this.gradientTransform);
        } else {
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(rectangle2D.getX(), rectangle2D.getY());
            affineTransform2.scale(rectangle2D.getWidth(), rectangle2D.getHeight());
            affineTransform2.concatenate(this.gradientTransform);
            paint = new RadialGradientPaint(float_, this.r, float_2, this.getStopFractions(), this.getStopColors(), cycleMethodEnum, MultipleGradientPaint.SRGB, affineTransform2);
        }
        return paint;
    }

    @Override
    public boolean updateTime(double d) throws SVGException {
        float f;
        boolean bl = super.updateTime(d);
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("cx")) && (f = styleAttribute.getFloatValueWithUnits()) != this.cx) {
            this.cx = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("cy")) && (f = styleAttribute.getFloatValueWithUnits()) != this.cy) {
            this.cy = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("fx")) && (f = styleAttribute.getFloatValueWithUnits()) != this.fx) {
            this.fx = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("fy")) && (f = styleAttribute.getFloatValueWithUnits()) != this.fy) {
            this.fy = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("r")) && (f = styleAttribute.getFloatValueWithUnits()) != this.r) {
            this.r = f;
            bl2 = true;
        }
        return bl;
    }
}

