/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JpegSegmentReader {
    @NotNull
    private final JpegSegmentData _segmentData;
    private static final byte SEGMENT_SOS = -38;
    private static final byte MARKER_EOI = -39;
    public static final byte SEGMENT_APP0 = -32;
    public static final byte SEGMENT_APP1 = -31;
    public static final byte SEGMENT_APP2 = -30;
    public static final byte SEGMENT_APP3 = -29;
    public static final byte SEGMENT_APP4 = -28;
    public static final byte SEGMENT_APP5 = -27;
    public static final byte SEGMENT_APP6 = -26;
    public static final byte SEGMENT_APP7 = -25;
    public static final byte SEGMENT_APP8 = -24;
    public static final byte SEGMENT_APP9 = -23;
    public static final byte SEGMENT_APPA = -22;
    public static final byte SEGMENT_APPB = -21;
    public static final byte SEGMENT_APPC = -20;
    public static final byte SEGMENT_APPD = -19;
    public static final byte SEGMENT_APPE = -18;
    public static final byte SEGMENT_APPF = -17;
    public static final byte SEGMENT_SOI = -40;
    public static final byte SEGMENT_DQT = -37;
    public static final byte SEGMENT_DHT = -60;
    public static final byte SEGMENT_SOF0 = -64;
    public static final byte SEGMENT_COM = -2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JpegSegmentReader(@NotNull File file) throws JpegProcessingException, IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            this._segmentData = this.readSegments(new BufferedInputStream(fileInputStream), false);
        }
    }

    public JpegSegmentReader(@NotNull byte[] byArray) throws JpegProcessingException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        this._segmentData = this.readSegments(bufferedInputStream, false);
    }

    public JpegSegmentReader(@NotNull InputStream inputStream, boolean bl) throws JpegProcessingException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this._segmentData = this.readSegments(bufferedInputStream, bl);
    }

    @Nullable
    public byte[] readSegment(byte by) {
        return this.readSegment(by, 0);
    }

    @Nullable
    public byte[] readSegment(byte by, int n) {
        return this._segmentData.getSegment(by, n);
    }

    @NotNull
    public Iterable<byte[]> readSegments(byte by) {
        return this._segmentData.getSegments(by);
    }

    public final int getSegmentCount(byte by) {
        return this._segmentData.getSegmentCount(by);
    }

    @NotNull
    public final JpegSegmentData getSegmentData() {
        return this._segmentData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private JpegSegmentData readSegments(@NotNull BufferedInputStream bufferedInputStream, boolean bl) throws JpegProcessingException {
        JpegSegmentData jpegSegmentData = new JpegSegmentData();
        try {
            boolean bl2;
            int n = 0;
            byte[] byArray = new byte[2];
            if (bufferedInputStream.read(byArray, 0, 2) != 2) {
                throw new JpegProcessingException("not a jpeg file");
            }
            boolean bl3 = bl2 = (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216;
            if (!bl2) {
                throw new JpegProcessingException("not a jpeg file");
            }
            n += 2;
            while (true) {
                if (!this.checkForBytesOnStream(bufferedInputStream, 4, bl)) {
                    throw new JpegProcessingException("stream ended before segment header could be read");
                }
                byte by = (byte)(bufferedInputStream.read() & 0xFF);
                if ((by & 0xFF) != 255) {
                    throw new JpegProcessingException("expected jpeg segment start identifier 0xFF at offset " + n + ", not 0x" + Integer.toHexString(by & 0xFF));
                }
                ++n;
                byte by2 = (byte)(bufferedInputStream.read() & 0xFF);
                ++n;
                byte[] byArray2 = new byte[2];
                if (bufferedInputStream.read(byArray2, 0, 2) != 2) {
                    throw new JpegProcessingException("Jpeg data ended unexpectedly.");
                }
                n += 2;
                int n2 = byArray2[0] << 8 & 0xFF00 | byArray2[1] & 0xFF;
                if (!this.checkForBytesOnStream(bufferedInputStream, n2 -= 2, bl)) {
                    throw new JpegProcessingException("segment size would extend beyond file stream length");
                }
                if (n2 < 0) {
                    throw new JpegProcessingException("segment size would be less than zero");
                }
                byte[] byArray3 = new byte[n2];
                if (bufferedInputStream.read(byArray3, 0, n2) != n2) {
                    throw new JpegProcessingException("Jpeg data ended unexpectedly.");
                }
                n += n2;
                if ((by2 & 0xFF) == 218) {
                    JpegSegmentData jpegSegmentData2 = jpegSegmentData;
                    return jpegSegmentData2;
                }
                if ((by2 & 0xFF) == 217) {
                    JpegSegmentData jpegSegmentData3 = jpegSegmentData;
                    return jpegSegmentData3;
                }
                jpegSegmentData.addSegment(by2, byArray3);
                continue;
                break;
            }
        }
        catch (IOException iOException) {
            throw new JpegProcessingException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new JpegProcessingException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
            }
        }
    }

    private boolean checkForBytesOnStream(@NotNull BufferedInputStream bufferedInputStream, int n, boolean bl) throws IOException {
        if (!bl) {
            return n <= bufferedInputStream.available();
        }
        for (int i = 40; i > 0; --i) {
            if (n <= bufferedInputStream.available()) {
                return true;
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }
}

