/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class JpegSegmentData
implements Serializable {
    private static final long serialVersionUID = 7110175216435025451L;
    @NotNull
    private final HashMap<Byte, List<byte[]>> _segmentDataMap = new HashMap(10);

    public void addSegment(byte by, @NotNull byte[] byArray) {
        List<byte[]> list = this.getOrCreateSegmentList(by);
        list.add(byArray);
    }

    @Nullable
    public byte[] getSegment(byte by) {
        return this.getSegment(by, 0);
    }

    @Nullable
    public byte[] getSegment(byte by, int n) {
        List<byte[]> list = this.getSegmentList(by);
        if (list == null || list.size() <= n) {
            return null;
        }
        return list.get(n);
    }

    @NotNull
    public Iterable<byte[]> getSegments(byte by) {
        ArrayList arrayList = this.getSegmentList(by);
        return arrayList == null ? new ArrayList() : arrayList;
    }

    @Nullable
    public List<byte[]> getSegmentList(byte by) {
        return this._segmentDataMap.get(by);
    }

    @NotNull
    private List<byte[]> getOrCreateSegmentList(byte by) {
        ArrayList<byte[]> arrayList;
        if (this._segmentDataMap.containsKey(by)) {
            arrayList = this._segmentDataMap.get(by);
        } else {
            arrayList = new ArrayList();
            this._segmentDataMap.put(by, arrayList);
        }
        return arrayList;
    }

    public int getSegmentCount(byte by) {
        List<byte[]> list = this.getSegmentList(by);
        return list == null ? 0 : list.size();
    }

    public void removeSegmentOccurrence(byte by, int n) {
        List<byte[]> list = this._segmentDataMap.get(by);
        list.remove(n);
    }

    public void removeSegment(byte by) {
        this._segmentDataMap.remove(by);
    }

    public boolean containsSegment(byte by) {
        return this._segmentDataMap.containsKey(by);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(@NotNull File file, @NotNull JpegSegmentData jpegSegmentData) throws IOException {
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(file);
            new ObjectOutputStream(fileOutputStream).writeObject(jpegSegmentData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JpegSegmentData fromFile(@NotNull File file) throws IOException, ClassNotFoundException {
        try (ObjectInputStream objectInputStream = null;){
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            JpegSegmentData jpegSegmentData = (JpegSegmentData)objectInputStream.readObject();
            return jpegSegmentData;
        }
    }
}

