<?php
// {{{ICINGA_LICENSE_CODE}}}
// -----------------------------------------------------------------------------
// This file is part of icinga-web.
// 
// Copyright (c) 2009-present Icinga Developer Team.
// All rights reserved.
// 
// icinga-web is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// icinga-web is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with icinga-web.  If not, see <http://www.gnu.org/licenses/>.
// -----------------------------------------------------------------------------
// {{{ICINGA_LICENSE_CODE}}}


/**
 * BaseIcingaInstances
 *
 * This class has been auto-generated by the Doctrine ORM Framework
 *
 * @property integer $instance_id
 * @property string $instance_name
 * @property string $instance_description
 *
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseIcingaInstances extends Doctrine_Record {
    public function setTableDefinition() {
        $conn = $this->getTable()->getConnection();
        if(!$conn)
            $conn = Doctrine_Manager::getInstance()->getConnection(IcingaDoctrineDatabase::CONNECTION_ICINGA);
        $prefix = $conn->getPrefix();
        $this->setTableName($prefix.'instances');
        $this->hasColumn('instance_id', 'integer', 2, array(
                             'type' => 'integer',
                             'length' => 2,
                             'fixed' => false,
                             'unsigned' => false,
                             'primary' => true,
                             'autoincrement' => true,
                         ));
        $this->hasColumn('instance_name', 'string', 64, array(
                             'type' => 'string',
                             'length' => 64,
                             'fixed' => false,
                             'unsigned' => false,
                             'primary' => false,
                             'default' => '',
                             'notnull' => true,
                             'autoincrement' => false,
                         ));
        $this->hasColumn('instance_description', 'string', 128, array(
                             'type' => 'string',
                             'length' => 128,
                             'fixed' => false,
                             'unsigned' => false,
                             'primary' => false,
                             'default' => '',
                             'notnull' => true,
                             'autoincrement' => false,
                         ));
    }

    public function setUp() {
        $this->hasMany('IcingaHosts as hosts', array(
                           'local' => 'instance_id',
                           'foreign' => 'instance_id'
                       ));
        $this->hasMany('IcingaServices as services', array(
                           'local' => 'instance_id',
                           'foreign' => 'instance_id'
                       ));
        $this->hasMany('IcingaHostgroups as hostgroups', array(
                           'local' => 'instance_id',
                           'foreign' => 'instance_id'
                       ));
        $this->hasMany('IcingaServicegroups as servicegroups', array(
                           'local' => 'instance_id',
                           'foreign' => 'instance_id'
                       ));
        $this->hasMany('IcingaContactgroups as contactgroups', array(
                           'local' => 'instance_id',
                           'foreign' => 'instance_id'
                       ));
        $this->hasMany('IcingaContacts as contacts', array(
                           'local' => 'instance_id',
                           'foreign' => 'instance_id'
                       ));
        $this->hasOne('IcingaProgramstatus as programstatus', array(
                           'local' => 'instance_id',
                           'foreign' => 'instance_id'
        ));
        
        parent::setUp();
    }
}
