/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class StreamUtils {
    public static void closeSilently(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
    }

    public static String readStreamAsString(InputStream stream) throws IOException {
        return StreamUtils.readStreamAsString(stream, false);
    }

    public static String readStreamAsString(InputStream stream, boolean includeEndOfLines) throws IOException {
        String read;
        InputStreamReader is = new InputStreamReader(stream);
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(is);
        while ((read = br.readLine()) != null) {
            sb.append(read);
            if (!includeEndOfLines) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

