/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;

public class PolicyPanel
extends NamedBorderPanel {
    public PolicyPanel(JFrame frame, DeploymentConfiguration config) {
        super(Translator.R("CPHeadPolicy"), new GridBagLayout());
        this.addComponents(frame, config);
    }

    private void addComponents(JFrame frame, DeploymentConfiguration config) {
        JLabel aboutLabel = new JLabel("<html>" + Translator.R("CPPolicyDetail") + "</html>");
        String fileUrlString = config.getProperty("deployment.user.security.policy");
        JButton showUserPolicyButton = new JButton(Translator.R("CPButPolicy"));
        showUserPolicyButton.addActionListener(new ViewPolicyButtonAction(frame, fileUrlString));
        String pathPart = PolicyPanel.localFilePathFromUrlString(fileUrlString);
        showUserPolicyButton.setToolTipText(Translator.R("CPPolicyTooltip", FileUtils.displayablePath(pathPart, 60)));
        JTextField locationField = new JTextField(pathPart);
        locationField.setEditable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        this.add((Component)aboutLabel, c);
        c.weighty = 0.0;
        c.weightx = 0.0;
        ++c.gridy;
        this.add((Component)locationField, c);
        c.fill = 0;
        ++c.gridx;
        this.add((Component)showUserPolicyButton, c);
        c.fill = 1;
        Component filler1 = Box.createRigidArea(new Dimension(240, 1));
        Component filler2 = Box.createRigidArea(new Dimension(1, 1));
        ++c.gridx;
        this.add(filler1, c);
        --c.gridx;
        c.weighty = 1.0;
        ++c.gridy;
        this.add(filler2, c);
    }

    private static void launchPolicyTool(JFrame frame, String filePath) {
        try {
            File policyFile = new File(filePath).getCanonicalFile();
            OpenFileResult result = PolicyPanel.canOpenPolicyFile(policyFile);
            if (result == OpenFileResult.SUCCESS) {
                PolicyPanel.policyToolLaunchHelper(frame, filePath);
            } else if (result == OpenFileResult.CANT_WRITE) {
                PolicyPanel.showReadOnlyDialog(frame);
                PolicyPanel.policyToolLaunchHelper(frame, filePath);
            } else {
                PolicyPanel.showCouldNotOpenFileDialog(frame, policyFile.getPath(), result);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            PolicyPanel.showCouldNotOpenFileDialog(frame, filePath);
        }
    }

    private static void policyToolLaunchHelper(final JFrame frame, final String filePath) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ProcessBuilder pb = new ProcessBuilder("policytool", "-file", filePath).directory(new File(System.getProperty("user.home")));
                try {
                    pb.start();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    try {
                        PolicyPanel.reflectivePolicyToolLaunch(filePath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PolicyPanel.showCouldNotOpenFileDialog(frame, filePath, Translator.R("CPPolicyEditorNotFound"));
                    }
                }
            }
        }).start();
    }

    private static void reflectivePolicyToolLaunch(String filePath) throws Exception {
        Class<?> policyTool;
        try {
            policyTool = Class.forName("sun.security.tools.policytool.PolicyTool");
        }
        catch (ClassNotFoundException cnfe) {
            policyTool = Class.forName("sun.security.tools.PolicyTool");
        }
        Class[] signature = new Class[]{String[].class};
        Method main = policyTool.getMethod("main", signature);
        String[] args = new String[]{"-file", filePath};
        main.invoke(null, new Object[]{args});
    }

    private static OpenFileResult canOpenPolicyFile(File policyFile) {
        try {
            FileUtils.createParentDir(policyFile);
        }
        catch (IOException e) {
            return OpenFileResult.FAILURE;
        }
        if (policyFile.isDirectory()) {
            return OpenFileResult.NOT_FILE;
        }
        try {
            if (!policyFile.exists() && !policyFile.createNewFile()) {
                return OpenFileResult.CANT_CREATE;
            }
        }
        catch (IOException e) {
            return OpenFileResult.CANT_CREATE;
        }
        boolean read = policyFile.canRead();
        boolean write = policyFile.canWrite();
        if (read && write) {
            return OpenFileResult.SUCCESS;
        }
        if (read) {
            return OpenFileResult.CANT_WRITE;
        }
        return OpenFileResult.FAILURE;
    }

    private static void showCouldNotOpenFileDialog(JFrame frame, String filePath) {
        PolicyPanel.showCouldNotOpenFileDialog(frame, filePath, OpenFileResult.FAILURE);
    }

    private static void showCouldNotOpenFileDialog(JFrame frame, String filePath, OpenFileResult reason) {
        String message;
        switch (reason) {
            case CANT_CREATE: {
                message = Translator.R("RCantCreateFile", filePath);
                break;
            }
            case CANT_WRITE: {
                message = Translator.R("RCantWriteFile", filePath);
                break;
            }
            case NOT_FILE: {
                message = Translator.R("RExpectedFile", filePath);
                break;
            }
            default: {
                message = Translator.R("RCantOpenFile", filePath);
            }
        }
        PolicyPanel.showCouldNotOpenFileDialog(frame, filePath, message);
    }

    private static void showCouldNotOpenFileDialog(final JFrame frame, String filePath, final String message) {
        System.err.println("Could not open user JNLP policy");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(frame, message, Translator.R("Error"), 0);
            }
        });
    }

    private static void showReadOnlyDialog(final JFrame frame) {
        System.err.println("Opening user JNLP policy read-only");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(frame, Translator.R("RFileReadOnly"), Translator.R("Warning"), 2);
            }
        });
    }

    private static String localFilePathFromUrlString(String url) {
        try {
            URL u = new URL(url);
            return u.getPath();
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    private class ViewPolicyButtonAction
    implements ActionListener {
        private final JFrame frame;
        private final String fileUrlString;

        public ViewPolicyButtonAction(JFrame frame, String fileUrlString) {
            this.fileUrlString = fileUrlString;
            this.frame = frame;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                final URL fileUrl = new URL(this.fileUrlString);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PolicyPanel.launchPolicyTool(ViewPolicyButtonAction.this.frame, fileUrl.getPath());
                    }
                });
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                PolicyPanel.showCouldNotOpenFileDialog(this.frame, this.fileUrlString);
            }
        }
    }

    private static enum OpenFileResult {
        SUCCESS,
        FAILURE,
        CANT_CREATE,
        CANT_WRITE,
        NOT_FILE;

    }
}

