#!/bin/sh
export PATH='/usr/obj/hs-vector-0.10.9.1/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: vector
version: 0.10.9.1
id: vector-0.10.9.1-1010d9fb05d5cbdd0bbbccafb8c8b174

license: BSD3
copyright: (c) Roman Leshchinskiy 2008-2012
maintainer: Roman Leshchinskiy <rl@cse.unsw.edu.au>
stability:
homepage: https://github.com/haskell/vector
package-url:
synopsis: Efficient Arrays
description:  
             .
             An efficient implementation of Int-indexed arrays (both mutable
             and immutable), with a powerful loop optimisation framework .
             .
             It is structured as follows:
             .
             ["Data.Vector"] Boxed vectors of arbitrary types.
             .
             ["Data.Vector.Unboxed"] Unboxed vectors with an adaptive
             representation based on data type families.
             .
             ["Data.Vector.Storable"] Unboxed vectors of '\''Storable'\'' types.
             .
             ["Data.Vector.Primitive"] Unboxed vectors of primitive types as
             defined by the @primitive@ package. "Data.Vector.Unboxed" is more
             flexible at no performance cost.
             .
             ["Data.Vector.Generic"] Generic interface to the vector types.
             .
             There is also a (draft) tutorial on common uses of vector.
             .
             * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>
             .
             Changes in version 0.10.0.1
             .
             * Require @primitive@ to include workaround for a GHC array copying bug
             .
             Changes in version 0.10
             .
             * @NFData@ instances
             .
             * More efficient block fills
             .
             * Safe Haskell support removed
             .
category: Data, Data Structures
author: Roman Leshchinskiy <rl@cse.unsw.edu.au>
pkgpath: devel/hs-vector
exposed: True
exposed-modules: Data.Vector.Internal.Check Data.Vector.Fusion.Util
                 Data.Vector.Fusion.Stream.Size Data.Vector.Fusion.Stream.Monadic
                 Data.Vector.Fusion.Stream Data.Vector.Generic.Mutable
                 Data.Vector.Generic.Base Data.Vector.Generic.New
                 Data.Vector.Generic Data.Vector.Primitive.Mutable
                 Data.Vector.Primitive Data.Vector.Storable.Internal
                 Data.Vector.Storable.Mutable Data.Vector.Storable
                 Data.Vector.Unboxed.Base Data.Vector.Unboxed.Mutable
                 Data.Vector.Unboxed Data.Vector.Mutable Data.Vector
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/vector-0.10.9.1
library-dirs: /usr/local/lib/ghc/vector-0.10.9.1
hs-libraries: HSvector-0.10.9.1
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/vector-0.10.9.1/include
includes:
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         deepseq-1.3.0.2-63a1ab91b7017a28bb5d04cb1b5d2d02
         ghc-prim-0.3.1.0-a24f9c14c632d75b683d0f93283aea37
         primitive-0.5.2.1-1efb6a710569a6a23b761d538e2c75d2
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-vector-0.10.9.1/html/vector.haddock
haddock-html: /usr/local/share/doc/hs-vector-0.10.9.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
