#!/bin/sh
export PATH='/usr/obj/hs-snap-core-0.9.6.4/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: snap-core
version: 0.9.6.4
id: snap-core-0.9.6.4-03d78ae489a396c63027afffd7f00ac6

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
synopsis: Snap: A Haskell Web Framework (core interfaces and types)
description: Snap is a simple and fast web development framework and server written in
             Haskell. For more information or to download the latest version, you can
             visit the Snap project website at <http://snapframework.com/>.
             .
             This library contains the core definitions and types for the Snap framework,
             including:
             .
             1. Primitive types and functions for HTTP (requests, responses, cookies,
             post/query parameters, etc)
             .
             2. Type aliases and helper functions for Iteratee I/O
             .
             3. A monad for programming web handlers called \"Snap\", which allows:
             .
             * Stateful access to the HTTP request and response objects
             .
             * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
             to handle requests and chaining handlers together
             .
             * Early termination of the computation if you know early what you want
             to return and want to prevent further monadic processing
             .
             /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core",
             some iteratee utilities are in "Snap.Iteratee".
category: Web, Snap
author: James Sanders, Shu-yu Guo, Gregory Collins, Doug Beardsley
pkgpath: www/hs-snap-core
exposed: True
exposed-modules: Snap.Core Snap.Types Snap.Iteratee
                 Snap.Internal.Debug Snap.Internal.Exceptions
                 Snap.Internal.Http.Types Snap.Internal.Iteratee.Debug
                 Snap.Internal.Parsing Snap.Test Snap.Types.Headers
                 Snap.Util.FileServe Snap.Util.FileUploads Snap.Util.GZip
                 Snap.Util.Proxy Snap.Util.Readable
hidden-modules: Snap.Internal.Instances
                Snap.Internal.Iteratee.BoyerMooreHorspool
                Snap.Internal.Parsing.FastSet Snap.Internal.Routing
                Snap.Internal.Types Snap.Internal.Test.RequestBuilder
                Snap.Internal.Test.Assertions
trusted: False
import-dirs: /usr/local/lib/ghc/snap-core-0.9.6.4
library-dirs: /usr/local/lib/ghc/snap-core-0.9.6.4
hs-libraries: HSsnap-core-0.9.6.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: HUnit-1.2.5.2-787adf4463330986350e972335672d3e
         MonadCatchIO-transformers-0.3.1.2-62247321324d3e4a539fd9759ef95eea
         attoparsec-0.10.4.0-0ac2f673d8ce2452d1d5d7431ac6711d
         attoparsec-enumerator-0.3.1-6ea1b5e76d86d8f3065a07373b7dc761
         base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         blaze-builder-0.3.3.4-cc8529eae0cb63ae30a446e2fb6a0b82
         blaze-builder-enumerator-0.2.0.5-b4313223d5a72f9228aa2526a332f837
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         bytestring-mmap-0.2.2-089613d8a75cc15b069776b275ade6d2
         case-insensitive-1.1.0.3-9c8bdfaae18edea02ec088e971b0a08a
         containers-0.5.5.1-d4bd887fb97aa3a46cbadc13709b7653
         deepseq-1.3.0.2-63a1ab91b7017a28bb5d04cb1b5d2d02
         directory-1.2.1.0-255ee2a4a618c74613f025ccc4ecc082
         enumerator-0.4.20-ad119cc7a805e7f774e62a13ac0dd36f
         filepath-1.3.0.2-25a474a9272ae6260626ce0d70ad1cab
         hashable-1.2.2.0-6aae2a5ae00dba4cc06a8e388409e9ed
         mtl-2.1.3.1-96f1a7910a7553352339ed05fb61c269
         random-1.0.1.1-18033e0e7d0ae09dc4f8adbdce56b966
         regex-posix-0.95.2-ed4992dd3310f21bd5691b3823fc6d4a
         text-1.1.0.0-72236c81391c0a9a303f37559690d8fe
         time-1.4.2-311aa8e77a6af87dc3d662d572df62ec
         unix-2.7.0.1-49291e6beb52ca8844af5af8283d8383
         unix-compat-0.4.1.1-3589aa38a14654855a07a6d23daf3b16
         unordered-containers-0.2.4.0-2fd558fbd599b4e4c335e82ebd45f621
         vector-0.10.9.1-1010d9fb05d5cbdd0bbbccafb8c8b174
         zlib-enum-0.2.3-a30daa574694a0ee5f1b6ec3e2e94bde
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-core-0.9.6.4/html/snap-core.haddock
haddock-html: /usr/local/share/doc/hs-snap-core-0.9.6.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
