#!/bin/sh
export PATH='/usr/obj/hs-haskell-src-exts-1.14.0.1/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: haskell-src-exts
version: 1.14.0.1
id: haskell-src-exts-1.14.0.1-607b6ca927ff40e37f4cd3b13eda96ea

license: BSD3
copyright:
maintainer: Niklas Broberg <niklas.broberg@chalmers.se>
stability: Stable
homepage: https://github.com/haskell-suite/haskell-src-exts
package-url:
synopsis: Manipulating Haskell source: abstract syntax, lexer, parser, and pretty-printer
description: Haskell-Source with Extensions (HSE, haskell-src-exts)
             is an extension of the standard haskell-src package,
             and handles most registered syntactic extensions to Haskell, including:
             .
             * Multi-parameter type classes with functional dependencies
             .
             * Indexed type families (including associated types)
             .
             * Empty data declarations
             .
             * GADTs
             .
             * Implicit parameters
             .
             * Template Haskell
             .
             and a few more. All extensions implemented in GHC are supported.
             Apart from these standard extensions,
             it also handles regular patterns as per the HaRP extension
             as well as HSX-style embedded XML syntax.
category: Language
author: Niklas Broberg
pkgpath: lang/hs-haskell-src-exts
exposed: True
exposed-modules: Language.Haskell.Exts Language.Haskell.Exts.Lexer
                 Language.Haskell.Exts.Parser Language.Haskell.Exts.Pretty
                 Language.Haskell.Exts.Syntax Language.Haskell.Exts.Extension
                 Language.Haskell.Exts.Build Language.Haskell.Exts.Fixity
                 Language.Haskell.Exts.Comments Language.Haskell.Exts.SrcLoc
                 Language.Haskell.Exts.Annotated
                 Language.Haskell.Exts.Annotated.Syntax
                 Language.Haskell.Exts.Annotated.Fixity
                 Language.Haskell.Exts.Annotated.Build
                 Language.Haskell.Exts.Annotated.ExactPrint
                 Language.Haskell.Exts.Annotated.Simplify
hidden-modules: Language.Haskell.Exts.ExtScheme
                Language.Haskell.Exts.ParseMonad Language.Haskell.Exts.ParseSyntax
                Language.Haskell.Exts.InternalLexer
                Language.Haskell.Exts.ParseUtils
                Language.Haskell.Exts.InternalParser
trusted: False
import-dirs: /usr/local/lib/ghc/haskell-src-exts-1.14.0.1
library-dirs: /usr/local/lib/ghc/haskell-src-exts-1.14.0.1
hs-libraries: HShaskell-src-exts-1.14.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.5.0.0-470385a50d2b78598af85cfe9d988e1b
         base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         cpphs-1.13.3-1b8e90f74b6a979bd937d5fd292209ab
         pretty-1.1.1.1-0984f47ffe93ef3983c80b96280f1c3a
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-haskell-src-exts-1.14.0.1/html/haskell-src-exts.haddock
haddock-html: /usr/local/share/doc/hs-haskell-src-exts-1.14.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
