#!/bin/sh
export PATH='/usr/obj/hs-hackage-db-1.4/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: hackage-db
version: 1.4
id: hackage-db-1.4-ddb8cae8baa95a577ffb4bd360681e26

license: BSD3
copyright: Peter Simons
maintainer: Peter Simons <simons@cryp.to>
stability:
homepage: http://github.com/peti/hackage-db
package-url:
synopsis: provide access to the Hackage database via Data.Map
description: This module provides simple access to the Hackage database by means
             of @Data.Map@. Suppose you wanted to implement a utility that queries
             the set of available versions for a given package, the following
             program would do the trick:
             .
             > import qualified Distribution.Hackage.DB as DB
             > import Distribution.Text ( display )
             > import System.Environment ( getArgs )
             >
             > main :: IO ()
             > main = do
             >   pkgs <- getArgs
             >   db <- DB.readHackage
             >   let getVersions name = maybe [] DB.keys (DB.lookup name db)
             >   mapM_ (putStrLn . unwords . map display . getVersions) pkgs
             .
             When run, it would produce the following output:
             .
             > ./a.out containers deepseq cabal-install
             > 0.1.0.0 0.1.0.1 0.2.0.0 0.2.0.1 0.3.0.0 0.4.0.0
             > 1.0.0.0 1.1.0.0 1.1.0.1 1.1.0.2
             > 0.4.0 0.5.0 0.5.1 0.5.2 0.6.0 0.6.2 0.6.4 0.8.0 0.8.2 0.10.0 0.10.2
             .
             Note that once the database has been parsed, it can be accessed
             quickly, but the inital cost of reading @00-index.tar@ is fairly
             high.
category: Distribution
author: Peter Simons <simons@cryp.to>
pkgpath: databases/hs-hackage-db
exposed: True
exposed-modules: Distribution.Hackage.DB
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/hackage-db-1.4
library-dirs: /usr/local/lib/ghc/hackage-db-1.4
hs-libraries: HShackage-db-1.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: Cabal-1.18.1.5-47efa721418298711b33150cdd4f7ef6
         base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         containers-0.5.5.1-d4bd887fb97aa3a46cbadc13709b7653
         directory-1.2.1.0-255ee2a4a618c74613f025ccc4ecc082
         filepath-1.3.0.2-25a474a9272ae6260626ce0d70ad1cab
         tar-0.4.0.1-1d006b71c8ea0e8a0d826a00810a6ed7
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hackage-db-1.4/html/hackage-db.haddock
haddock-html: /usr/local/share/doc/hs-hackage-db-1.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
