#!/bin/sh
export PATH='/usr/obj/hs-crypto-api-0.13.2/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: crypto-api
version: 0.13.2
id: crypto-api-0.13.2-bcd8d1b88ec2398781ed0f4d7c219c08

license: BSD3
copyright: Thomas DuBuisson <thomas.dubuisson@gmail.com>
maintainer: Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability: stable
homepage: https://github.com/TomMD/crypto-api
package-url:
synopsis: A generic interface for cryptographic operations
description: A generic interface for cryptographic operations (hashes, ciphers, randomness).
             Maintainers of hash and cipher implementations are
             encouraged to add instances for the classes defined
             in Crypto.Classes.  Crypto users are similarly
             encouraged to use the interfaces defined in the Classes
             module.
             Any concepts or functions of general use to more than
             one cryptographic algorithm (ex: padding) is within
             scope of this package.
category: Data, Cryptography
author: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike)
pkgpath: security/hs-crypto-api
exposed: True
exposed-modules: Crypto.Classes Crypto.Types Crypto.HMAC
                 Crypto.Random Crypto.Padding Crypto.Modes Crypto.Util
                 Crypto.Classes.Exceptions
hidden-modules: Crypto.CPoly
trusted: False
import-dirs: /usr/local/lib/ghc/crypto-api-0.13.2
library-dirs: /usr/local/lib/ghc/crypto-api-0.13.2
hs-libraries: HScrypto-api-0.13.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         cereal-0.4.1.0-9d42a4c31bc1d35f6a410f5e79e67215
         entropy-0.2.1-c6c0dbdffd26caaccbab0a1c1900201b
         tagged-0.7.3-4aece88b76fce3c636457239733a4dfa
         transformers-0.3.0.0-6458c21515cab7c1cf21e53141557a1c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-crypto-api-0.13.2/html/crypto-api.haddock
haddock-html: /usr/local/share/doc/hs-crypto-api-0.13.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
