#!/bin/sh
export PATH='/usr/obj/hs-HTTP-4000.2.10/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: HTTP
version: 4000.2.10
id: HTTP-4000.2.10-f899b20722d95264e2a176f9b134f446

license: BSD3
copyright:
maintainer: Ganesh Sittampalam <http@projects.haskell.org>
stability:
homepage: https://github.com/haskell/HTTP
package-url:
synopsis: A library for client-side HTTP
description: The HTTP package supports client-side web programming in Haskell. It lets you set up
             HTTP connections, transmitting requests and processing the responses coming back, all
             from within the comforts of Haskell. It'\''s dependent on the network package to operate,
             but other than that, the implementation is all written in Haskell.
             .
             A basic API for issuing single HTTP requests + receiving responses is provided. On top
             of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
             it taking care of handling the management of persistent connections, proxies,
             state (cookies) and authentication credentials required to handle multi-step
             interactions with a web server.
             .
             The representation of the bytes flowing across is extensible via the use of a type class,
             letting you pick the representation of requests and responses that best fits your use.
             Some pre-packaged, common instances are provided for you (@ByteString@, @String@.)
             .
             Here'\''s an example use:
             .
             >
             >    do
             >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
             >              -- fetch document and return it (as a '\''String'\''.)
             >      fmap (take 100) (getResponseBody rsp)
             >
             >    do
             >      (_, rsp)
             >         <- Network.Browser.browse $ do
             >               setAllowRedirects True -- handle HTTP redirects
             >               request $ getRequest "http://www.haskell.org/"
             >      return (take 100 (rspBody rsp))
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
pkgpath: net/hs-HTTP
exposed: True
exposed-modules: Network.BufferType Network.Stream
                 Network.StreamDebugger Network.StreamSocket Network.TCP
                 Network.HTTP Network.HTTP.Headers Network.HTTP.Base
                 Network.HTTP.Stream Network.HTTP.Auth Network.HTTP.Cookie
                 Network.HTTP.Proxy Network.HTTP.HandleStream Network.Browser
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
trusted: False
import-dirs: /usr/local/lib/ghc/HTTP-4000.2.10
library-dirs: /usr/local/lib/ghc/HTTP-4000.2.10
hs-libraries: HSHTTP-4000.2.10
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.5.0.0-470385a50d2b78598af85cfe9d988e1b
         base-4.7.0.2-e1c96ce41208f09c293083d78870d5a2
         bytestring-0.10.4.0-84f2b632cefc94e5dfeafb660607fcbd
         mtl-2.1.3.1-96f1a7910a7553352339ed05fb61c269
         network-2.4.2.3-878f8bfcc369ed62265df39b168036b0
         old-time-1.1.0.2-e3f776e97c1a6ff1770b04943a7ef7c6
         parsec-3.1.5-7f6674da593b27c3fdd904274a0dcd1e
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-HTTP-4000.2.10/html/HTTP.haddock
haddock-html: /usr/local/share/doc/hs-HTTP-4000.2.10/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
