/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.provisional.observable.value;

import org.eclipse.jface.internal.databinding.provisional.observable.IChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.IStaleListener;
import org.eclipse.jface.internal.databinding.provisional.observable.ObservableTracker;
import org.eclipse.jface.internal.databinding.provisional.observable.value.AbstractObservableValue;
import org.eclipse.jface.internal.databinding.provisional.observable.value.ValueDiff;

public abstract class ComputedValue
extends AbstractObservableValue {
    private boolean dirty = true;
    private boolean stale = false;
    private Object cachedValue = null;
    private IObservable[] dependencies = new IObservable[0];
    private PrivateInterface privateInterface = new PrivateInterface();
    private Object valueType;

    public ComputedValue() {
        this(Object.class);
    }

    public ComputedValue(Object valueType) {
        this.valueType = valueType;
    }

    public final Object doGetValue() {
        if (this.dirty) {
            IObservable[] newDependencies = ObservableTracker.runAndMonitor(this.privateInterface, this.privateInterface, null);
            this.stale = false;
            int i = 0;
            while (i < newDependencies.length) {
                IObservable observable = newDependencies[i];
                if (observable.isStale()) {
                    this.stale = true;
                } else {
                    observable.addStaleListener(this.privateInterface);
                }
                ++i;
            }
            this.dependencies = newDependencies;
            this.dirty = false;
        }
        return this.cachedValue;
    }

    protected abstract Object calculate();

    protected final void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            int i = 0;
            while (i < this.dependencies.length) {
                IObservable observable = this.dependencies[i];
                observable.removeChangeListener(this.privateInterface);
                observable.removeStaleListener(this.privateInterface);
                ++i;
            }
            final Object oldValue = this.cachedValue;
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return oldValue;
                }

                public Object getNewValue() {
                    return ComputedValue.this.getValue();
                }
            });
        }
    }

    public boolean isStale() {
        this.getValue();
        return this.stale;
    }

    public Object getValueType() {
        return this.valueType;
    }

    private class PrivateInterface
    implements Runnable,
    IChangeListener,
    IStaleListener {
        private PrivateInterface() {
        }

        public void run() {
            ComputedValue.this.cachedValue = ComputedValue.this.calculate();
        }

        public void handleStale(IObservable source) {
            if (!ComputedValue.this.dirty && !ComputedValue.this.stale) {
                ComputedValue.this.stale = true;
                ComputedValue.this.fireStale();
            }
        }

        public void handleChange(IObservable source) {
            ComputedValue.this.makeDirty();
        }
    }
}

