/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.console;

import org.eclipse.ant.internal.ui.console.AbstractJavacPatternMatcher;
import org.eclipse.ui.console.PatternMatchEvent;

public class EclipseJavacPatternMatcher
extends AbstractJavacPatternMatcher {
    private static final String fgError = "ERROR in";
    private static final String fgWarning = "WARNING in";

    public void matchFound(PatternMatchEvent event) {
        String filePath;
        String matchedText = this.getMatchedText(event);
        if (matchedText == null) {
            return;
        }
        int index = matchedText.indexOf(fgError);
        Integer type = fgErrorType;
        if (index == -1) {
            index = matchedText.indexOf(fgWarning);
            filePath = matchedText.substring(index + 10).trim();
            type = fgWarningType;
        } else {
            filePath = matchedText.substring(index + 8).trim();
        }
        int fileStart = matchedText.indexOf(filePath);
        int eventOffset = event.getOffset() + fileStart;
        int eventLength = filePath.length();
        int lineNumber = this.getLineNumber(eventOffset);
        this.addLink(filePath, lineNumber, eventOffset, eventLength, type);
    }
}

