/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;

public class DependencyGraph {
    private static final DependencyGraph INSTANCE = new DependencyGraph();
    private final Map dependencies = new HashMap();

    public static DependencyGraph getInstance() {
        return INSTANCE;
    }

    public IProject[] getReferencingComponents(IProject target) {
        Set referencingComponents = this.internalGetReferencingComponents(target);
        return referencingComponents.toArray(new IProject[referencingComponents.size()]);
    }

    public void addReference(IProject target, IProject referencingComponent) {
        this.internalGetReferencingComponents(target).add(referencingComponent);
    }

    public void removeReference(IProject target, IProject referencingComponent) {
        this.internalGetReferencingComponents(target).remove(referencingComponent);
    }

    protected Set internalGetReferencingComponents(IProject target) {
        HashSet referencingComponents = (HashSet)this.dependencies.get(target);
        if (referencingComponents == null) {
            referencingComponents = new HashSet();
            this.dependencies.put(target, referencingComponents);
        }
        return referencingComponents;
    }

    public void clear() {
        this.dependencies.clear();
    }
}

