/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.IVersion;
import org.eclipse.wst.common.project.facet.core.internal.Versionable;

public final class VersionExpr
implements IVersionExpr {
    private static final int SM1_START = 0;
    private static final int SM1_PARSING_START_VERSION = 1;
    private static final int SM1_PARSING_END_VERSION = 2;
    private static final int SM1_FINISHED_RANGE_INCLUSIVE = 3;
    private static final int SM1_FINISHED_RANGE_EXCLUSIVE = 4;
    private static final int SM1_PARSING_WILDCARD = 5;
    private static final int SM2_VERSION_START = 0;
    private static final int SM2_VERSION_CONTINUING = 1;
    private static final int SM2_ESCAPE = 2;
    private final Versionable versionable;
    private final Comparator comparator;
    private final List subexprs;
    private final String usedInPlugin;

    public VersionExpr(Object versionable, String expr, String usedInPlugin) throws CoreException {
        this((Versionable)versionable, expr, usedInPlugin);
    }

    public VersionExpr(Versionable versionable, String expr, String usedInPlugin) throws CoreException {
        this.versionable = versionable;
        this.comparator = versionable.getVersionComparator();
        this.subexprs = new ArrayList();
        this.usedInPlugin = usedInPlugin;
        int state = 0;
        Range range = null;
        boolean usingDeprecatedSyntax = false;
        MutableInteger position = new MutableInteger();
        while (position.value < expr.length()) {
            char ch = expr.charAt(position.value);
            switch (state) {
                case 0: {
                    if (ch == '[') {
                        range = new Range();
                        range.includesStartVersion = true;
                        state = 1;
                        break;
                    }
                    if (ch == '(') {
                        range = new Range();
                        range.includesStartVersion = false;
                        state = 1;
                        break;
                    }
                    if (ch == '*') {
                        this.subexprs.add(new Wildcard());
                        state = 5;
                        break;
                    }
                    if (ch == ' ' || ch == ',') break;
                    StringBuffer buf = new StringBuffer();
                    int exitState = this.parseVersion(expr, position, buf);
                    if (exitState == 0) {
                        String vstr = buf.toString();
                        Range r = new Range();
                        if (vstr.startsWith(">=")) {
                            r.startVersion = this.parseVersion(vstr.substring(2));
                            r.includesStartVersion = true;
                            usingDeprecatedSyntax = true;
                        } else if (vstr.startsWith(">")) {
                            r.startVersion = this.parseVersion(vstr.substring(1));
                            r.includesStartVersion = false;
                            usingDeprecatedSyntax = true;
                        } else if (vstr.startsWith("<=")) {
                            r.endVersion = this.parseVersion(vstr.substring(2));
                            r.includesEndVersion = true;
                            usingDeprecatedSyntax = true;
                        } else if (vstr.startsWith("<")) {
                            r.endVersion = this.parseVersion(vstr.substring(1));
                            r.includesEndVersion = false;
                            usingDeprecatedSyntax = true;
                        } else {
                            r.startVersion = this.parseVersion(vstr);
                            r.includesStartVersion = true;
                            r.endVersion = r.startVersion;
                            r.includesEndVersion = true;
                        }
                        this.subexprs.add(r);
                        break;
                    }
                    if (exitState == 3 || exitState == 4) {
                        range = new Range();
                        range.endVersion = this.parseVersion(buf.toString());
                        state = exitState;
                        --position.value;
                        break;
                    }
                    throw VersionExpr.createInvalidVersionExprException(expr);
                }
                case 1: {
                    StringBuffer buf = new StringBuffer();
                    int exitState = this.parseVersion(expr, position, buf);
                    if (exitState == 0) {
                        range.startVersion = this.parseVersion(buf.toString());
                        this.subexprs.add(range);
                        range = null;
                        state = exitState;
                        break;
                    }
                    if (exitState == 2) {
                        range.startVersion = this.parseVersion(buf.toString());
                        state = exitState;
                        break;
                    }
                    throw VersionExpr.createInvalidVersionExprException(expr);
                }
                case 2: {
                    StringBuffer buf = new StringBuffer();
                    int exitState = this.parseVersion(expr, position, buf);
                    if (exitState == 3 || exitState == 4) {
                        range.endVersion = this.parseVersion(buf.toString());
                        state = exitState;
                        --position.value;
                        break;
                    }
                    throw VersionExpr.createInvalidVersionExprException(expr);
                }
                case 3: 
                case 4: {
                    range.includesEndVersion = state == 3;
                    this.subexprs.add(range);
                    range = null;
                    state = 0;
                    break;
                }
                case 5: {
                    if (ch != ' ') {
                        if (ch == ',') {
                            state = 0;
                        } else {
                            throw VersionExpr.createInvalidVersionExprException(expr);
                        }
                    }
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++position.value;
        }
        if (usingDeprecatedSyntax) {
            String msg = this.usedInPlugin == null ? Resources.deprecatedSyntaxNoPlugin : NLS.bind((String)Resources.deprecatedSyntax, (Object)this.usedInPlugin);
            FacetCorePlugin.logWarning(msg, true);
        }
    }

    private int parseVersion(String str, MutableInteger position, StringBuffer version) throws CoreException {
        int localState = 0;
        int exitState = -1;
        while (exitState == -1 && position.value < str.length()) {
            char ch = str.charAt(position.value);
            switch (localState) {
                case 0: {
                    if (ch == '[' || ch == '(' || ch == ']' || ch == ')' || ch == '-' || ch == ',') {
                        throw VersionExpr.createInvalidVersionExprException(str);
                    }
                    if (ch == '\\') {
                        localState = 2;
                        break;
                    }
                    if (ch == ' ') break;
                    version.append(ch);
                    localState = 1;
                    break;
                }
                case 1: {
                    if (ch == '[' || ch == '(') {
                        throw VersionExpr.createInvalidVersionExprException(str);
                    }
                    if (ch == '\\') {
                        localState = 2;
                        break;
                    }
                    if (ch == ',') {
                        exitState = 0;
                        break;
                    }
                    if (ch == '-') {
                        exitState = 2;
                        break;
                    }
                    if (ch == ']') {
                        exitState = 3;
                        break;
                    }
                    if (ch == ')') {
                        exitState = 4;
                        break;
                    }
                    if (ch == ' ') break;
                    version.append(ch);
                    break;
                }
                case 2: {
                    version.append(ch);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++position.value;
        }
        --position.value;
        if (exitState != -1) {
            return exitState;
        }
        if (localState == 1) {
            return 0;
        }
        throw VersionExpr.createInvalidVersionExprException(str);
    }

    private String parseVersion(String str) throws CoreException {
        if (!this.versionable.hasVersion(str)) {
            String msg = this.versionable.createVersionNotFoundErrMsg(str);
            IStatus st = FacetCorePlugin.createErrorStatus(msg);
            throw new CoreException(st);
        }
        return this.versionable.getVersionInternal(str).getVersionString();
    }

    public boolean evaluate(IVersion ver) throws CoreException {
        return this.evaluate(ver.getVersionString());
    }

    public boolean evaluate(String ver) {
        Iterator itr = this.subexprs.iterator();
        while (itr.hasNext()) {
            if (!((ISubExpr)itr.next()).evaluate(ver)) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleVersionMatch() {
        ISubExpr subExpr;
        if (this.subexprs.size() == 1 && (subExpr = (ISubExpr)this.subexprs.get(0)) instanceof Range) {
            Range range = (Range)subExpr;
            if (range.startVersion == range.endVersion && range.includesStartVersion == range.includesEndVersion) {
                return true;
            }
        }
        return false;
    }

    public boolean isSimpleAllowNewer() {
        ISubExpr subExpr;
        if (this.subexprs.size() == 1 && (subExpr = (ISubExpr)this.subexprs.get(0)) instanceof Range) {
            Range range = (Range)subExpr;
            if (range.startVersion != null && range.endVersion == null && range.includesStartVersion) {
                return true;
            }
        }
        return false;
    }

    public boolean isWildcard() {
        return this.subexprs.size() == 1 && this.subexprs.get(0) instanceof Wildcard;
    }

    public String getFirstVersion() {
        if (this.isSingleVersionMatch() || this.isSimpleAllowNewer()) {
            Range range = (Range)this.subexprs.get(0);
            return range.startVersion;
        }
        throw new IllegalStateException();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator itr = this.subexprs.iterator();
        while (itr.hasNext()) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(itr.next().toString());
        }
        return buf.toString();
    }

    public String toDisplayString() {
        ISubExpr subexpr;
        if (this.subexprs.size() == 1 && (subexpr = (ISubExpr)this.subexprs.get(0)) instanceof Range) {
            Range r = (Range)subexpr;
            if (r.isSingleVersion()) {
                return r.startVersion;
            }
            if (r.endVersion == null && r.includesStartVersion) {
                return NLS.bind((String)Resources.versionOrNewer, (Object)r.startVersion);
            }
        }
        boolean onlySingleVersions = true;
        Iterator itr = this.subexprs.iterator();
        while (itr.hasNext()) {
            ISubExpr subexpr2 = (ISubExpr)itr.next();
            if (subexpr2 instanceof Range && ((Range)subexpr2).isSingleVersion()) continue;
            onlySingleVersions = false;
            break;
        }
        if (onlySingleVersions) {
            StringBuffer buf = new StringBuffer();
            Iterator itr2 = this.subexprs.iterator();
            while (itr2.hasNext()) {
                Range r = (Range)itr2.next();
                if (buf.length() > 0) {
                    if (itr2.hasNext()) {
                        buf.append(", ");
                    } else {
                        buf.append(" or ");
                    }
                }
                buf.append(r.startVersion);
            }
            return buf.toString();
        }
        return this.toString();
    }

    private static CoreException createInvalidVersionExprException(String str) {
        String msg = NLS.bind((String)Resources.invalidVersionExpr, (Object)str);
        IStatus st = FacetCorePlugin.createErrorStatus(msg);
        return new CoreException(st);
    }

    private static interface ISubExpr {
        public boolean evaluate(String var1);
    }

    private static final class MutableInteger {
        public int value = 0;

        private MutableInteger() {
        }
    }

    private final class Range
    implements ISubExpr {
        public String startVersion = null;
        public boolean includesStartVersion = false;
        public String endVersion = null;
        public boolean includesEndVersion = false;

        private Range() {
        }

        public boolean isSingleVersion() {
            return this.startVersion.equals(this.endVersion) && this.includesStartVersion == this.includesEndVersion;
        }

        public boolean evaluate(String version) {
            int res;
            Comparator comp = VersionExpr.this.comparator;
            if (!(this.startVersion == null || (res = comp.compare(version, this.startVersion)) > 0 || res == 0 && this.includesStartVersion)) {
                return false;
            }
            return this.endVersion == null || (res = comp.compare(version, this.endVersion)) < 0 || res == 0 && this.includesEndVersion;
        }

        public String toString() {
            if (this.startVersion.equals(this.endVersion) && this.includesStartVersion == this.includesEndVersion) {
                return this.startVersion;
            }
            StringBuffer buf = new StringBuffer();
            if (this.startVersion != null) {
                buf.append(this.includesStartVersion ? (char)'[' : '(');
                buf.append(this.startVersion);
            }
            if (this.endVersion != null) {
                if (buf.length() != 0) {
                    buf.append('-');
                }
                buf.append(this.endVersion);
                buf.append(this.includesEndVersion ? (char)']' : ')');
            }
            return buf.toString();
        }
    }

    private static final class Resources
    extends NLS {
        public static String invalidVersionExpr;
        public static String deprecatedSyntax;
        public static String deprecatedSyntaxNoPlugin;
        public static String versionOrNewer;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.VersionExpr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.core.internal.VersionExpr$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }

    private static final class Wildcard
    implements ISubExpr {
        private Wildcard() {
        }

        public boolean evaluate(String version) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }
}

