/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.hyperlink;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

class WorkspaceFileHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private IFile fFile;
    private IRegion fHighlightRange;

    public WorkspaceFileHyperlink(IRegion region, IFile file) {
        this.fRegion = region;
        this.fFile = file;
    }

    public WorkspaceFileHyperlink(IRegion region, IFile file, IRegion range) {
        this.fRegion = region;
        this.fFile = file;
        this.fHighlightRange = range;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }

    public void open() {
        if (this.fFile != null && this.fFile.exists()) {
            try {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)this.fFile, (boolean)true);
                if (this.fHighlightRange != null && editor instanceof ITextEditor) {
                    ((ITextEditor)editor).setHighlightRange(this.fHighlightRange.getOffset(), this.fHighlightRange.getLength(), true);
                }
            }
            catch (PartInitException pie) {
                Logger.log(202, pie.getMessage(), pie);
            }
        }
    }
}

