/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.log.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.log.Log;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.log.impl.MessageEntryImpl;
import org.eclipse.wst.wsi.internal.core.util.TestUtils;
import org.eclipse.wst.wsi.internal.core.util.Utils;

public class LogImpl
implements Log {
    protected String logURI = null;
    protected String startTimestamp = null;
    protected Vector logEntryList = new Vector();
    protected MessageEntry lastLogEntry = null;
    protected String logTitle = "Message Log File";
    protected String styleSheetString = null;

    public void addLogEntry(MessageEntry logEntry) throws WSIException {
        this.lastLogEntry = logEntry;
        this.logEntryList.add(logEntry);
    }

    public int getEntryCount() {
        return this.logEntryList.size();
    }

    public MessageEntry getLogEntry(int index) {
        return (MessageEntry)this.logEntryList.elementAt(index);
    }

    public Vector getLogEntryList() {
        return this.logEntryList;
    }

    public MessageEntry getLastLogEntry() {
        return this.lastLogEntry;
    }

    public MessageEntry createLogEntry() {
        return new MessageEntryImpl();
    }

    public String getLocation() {
        return this.logURI;
    }

    public void setLocation(String documentURI) {
        this.logURI = documentURI;
    }

    public void setStyleSheetString(String styleSheetString) {
        this.styleSheetString = styleSheetString;
    }

    public String getStartXMLString(String namespaceName) {
        String comment;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = String.valueOf(nsName) + ":";
        }
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (this.styleSheetString != null) {
            pw.println(this.styleSheetString);
        }
        if ((comment = TestUtils.getXMLComment()) != null) {
            pw.print(comment);
        }
        pw.print("<" + nsName + "log");
        pw.println(" timestamp=\"" + Utils.getTimestamp() + "\"");
        pw.println("    xmlns=\"http://www.ws-i.org/testing/2004/07/log/\"");
        pw.println("    xmlns:wsi-monConfig=\"http://www.ws-i.org/testing/2004/07/monitorConfig/\"");
        pw.println("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
        return sw.toString();
    }

    public String getEndXMLString(String namespaceName) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String nsName = namespaceName;
        if (!nsName.equals("") && !nsName.endsWith(":")) {
            nsName = String.valueOf(nsName) + ":";
        }
        pw.println("</" + nsName + "log" + ">");
        return sw.toString();
    }

    public String toXMLString(String namespaceName) {
        return null;
    }
}

