/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.widgets;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.command.internal.env.context.PersistentResourceContext;
import org.eclipse.wst.command.internal.env.core.common.Condition;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.data.DataFlowManager;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistryImpl;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.core.fragment.SequenceFragment;
import org.eclipse.wst.command.internal.env.core.fragment.SimpleFragment;
import org.eclipse.wst.command.internal.env.eclipse.EclipseEnvironment;
import org.eclipse.wst.command.internal.env.ui.EnvironmentUIMessages;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseStatusHandler;
import org.eclipse.wst.command.internal.env.ui.registry.WidgetRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.CommandWidgetBinding;
import org.eclipse.wst.command.internal.env.ui.widgets.CurrentPageCommand;
import org.eclipse.wst.command.internal.env.ui.widgets.DataObjectCommand;
import org.eclipse.wst.command.internal.env.ui.widgets.SelectionCommand;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleCanFinishRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.SimplePageFactory;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.WizardPageFactory;
import org.eclipse.wst.command.internal.env.ui.widgets.WizardPageManager;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.osgi.framework.Bundle;

public class DynamicWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private String iconBannerName_;
    private Bundle bundle_;
    private SimpleCanFinishRegistry canFinishRegistry_;
    private String wizardTitle_;
    private DataObjectCommand dataObjectCommand_ = null;
    private WizardPageManager pageManager_;
    protected IConfigurationElement wizardElement_;
    protected IConfigurationElement originalElement_;
    protected CommandWidgetBinding commandWidgetBinding_;

    public DynamicWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String wizardId = config.getAttribute("id");
        this.setInitialData(wizardId);
        this.originalElement_ = config;
    }

    public void setInitialData(CommandWidgetBinding binding, Bundle bundle, String iconBannerPath, String wizardTitle) {
        this.commandWidgetBinding_ = binding;
        this.bundle_ = bundle;
        this.iconBannerName_ = iconBannerPath;
        this.wizardTitle_ = wizardTitle;
    }

    public void setInitialData(String wizardId) throws CoreException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.wst.command.env.dynamicWizard");
        IExtension[] extensions = point.getExtensions();
        int index = 0;
        while (index < extensions.length) {
            String id;
            IConfigurationElement[] elements = extensions[index].getConfigurationElements();
            if (elements.length == 1 && elements[0].getName().equals("dynamicWizard") && (id = elements[0].getAttribute("id")) != null && id.equals(wizardId)) {
                this.wizardElement_ = elements[0];
                break;
            }
            ++index;
        }
        if (this.wizardElement_ == null) {
            Status status = new Status(4, "id", 0, NLS.bind((String)EnvironmentUIMessages.MSG_ERROR_WIZARD_ID_NOT_FOUND, (Object[])new String[]{wizardId}), null);
            throw new CoreException((IStatus)status);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        PersistentResourceContext context = PersistentResourceContext.getInstance();
        EclipseStatusHandler handler = new EclipseStatusHandler();
        EclipseEnvironment environment = new EclipseEnvironment(null, (ResourceContext)context, (IStatusHandler)handler);
        DataMappingRegistryImpl dataRegistry_ = new DataMappingRegistryImpl();
        SimpleWidgetRegistry widgetRegistry_ = new SimpleWidgetRegistry();
        DataFlowManager dataManager = new DataFlowManager(dataRegistry_, (IEnvironment)environment);
        try {
            this.commandWidgetBinding_ = (CommandWidgetBinding)this.wizardElement_.createExecutableExtension("class");
            this.bundle_ = Platform.getBundle((String)this.wizardElement_.getNamespace());
            this.iconBannerName_ = this.wizardElement_.getAttribute("iconbanner");
            this.wizardTitle_ = this.wizardElement_.getAttribute("title");
        }
        catch (CoreException exc) {
            exc.printStackTrace();
        }
        this.dataObjectCommand_ = new DataObjectCommand();
        this.canFinishRegistry_ = new SimpleCanFinishRegistry();
        this.pageManager_ = new WizardPageManager(widgetRegistry_, this.getWizardPageFactory(), (IWizard)this, dataManager, environment);
        this.pageManager_.setRootFragment(this.getRootFragment(selection, this.pageManager_));
        this.commandWidgetBinding_.registerWidgetMappings(widgetRegistry_);
        this.commandWidgetBinding_.registerDataMappings((DataMappingRegistry)dataRegistry_);
        this.commandWidgetBinding_.registerCanFinish(this.canFinishRegistry_);
        Condition canFinish = new Condition(){

            public boolean evaluate() {
                IWizardPage currentPage = DynamicWizard.this.pageManager_.getCurrentPage();
                return currentPage != null ? currentPage.isPageComplete() : true;
            }
        };
        this.canFinishRegistry_.add(canFinish);
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        if (this.iconBannerName_ != null && this.iconBannerName_.length() > 0) {
            try {
                URL installURL = this.bundle_.getEntry("/");
                URL imageURL = new URL(installURL, this.iconBannerName_);
                ImageDescriptor image = ImageDescriptor.createFromURL((URL)imageURL);
                if (image != null) {
                    this.setDefaultPageImageDescriptor(image);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (this.wizardTitle_ != null && this.wizardTitle_.length() > 0) {
            this.setWindowTitle(this.wizardTitle_);
        }
    }

    protected WizardPageFactory getWizardPageFactory() {
        return new SimplePageFactory();
    }

    public boolean canFinish() {
        int length = this.canFinishRegistry_.size();
        boolean result = true;
        int index = 0;
        while (index < length) {
            Condition condition = (Condition)this.canFinishRegistry_.elementAt(index);
            result = condition.evaluate();
            if (!result) break;
            ++index;
        }
        return result;
    }

    public IWizardPage getStartingPage() {
        return this.pageManager_.getStartingPage();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return this.pageManager_.getNextPage();
    }

    public boolean performFinish() {
        boolean result = this.pageManager_.performFinish();
        if (result) {
            this.cleanup();
        }
        return result;
    }

    public boolean performCancel() {
        boolean result = this.pageManager_.performCancel();
        if (result) {
            this.cleanup();
        }
        return result;
    }

    public Object getDataObject() {
        return this.dataObjectCommand_.getDataObject();
    }

    protected CommandFragment getRootFragment(IStructuredSelection selection, WizardPageManager pageManager) {
        SequenceFragment root = new SequenceFragment();
        root.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new SelectionCommand(selection), ""));
        root.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)new CurrentPageCommand(pageManager), ""));
        root.add(this.commandWidgetBinding_.create().create());
        root.add((CommandFragment)new SimpleFragment((AbstractDataModelOperation)this.dataObjectCommand_, ""));
        return root;
    }

    protected IConfigurationElement getConfigElement() {
        return this.wizardElement_;
    }

    private void cleanup() {
        this.iconBannerName_ = null;
        this.bundle_ = null;
        this.canFinishRegistry_ = null;
        this.pageManager_ = null;
        this.wizardTitle_ = null;
        this.commandWidgetBinding_ = null;
        WidgetRegistry.initialize();
    }
}

