/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.perspective;

import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLPerspective;

public class LaunchOptionsManager {
    private static LaunchOptionsManager instance_;
    private Hashtable optionsTable_ = new Hashtable();

    private LaunchOptionsManager() {
    }

    public static LaunchOptionsManager getInstance() {
        if (instance_ == null) {
            instance_ = new LaunchOptionsManager();
        }
        return instance_;
    }

    public synchronized void manage(String key, Object value, ServletContext application) {
        if (value instanceof String) {
            this.manageSession(key, (String)value, application);
        } else if (value instanceof Hashtable) {
            this.manageOptions(key, (Hashtable)value, application);
        }
    }

    private void manageSession(String key, String sessionId, ServletContext application) {
        Object obj = this.optionsTable_.remove(key);
        if (obj != null && obj instanceof Hashtable) {
            this.loadOptions(sessionId, (Hashtable)obj, application);
        } else {
            this.optionsTable_.put(key, sessionId);
        }
    }

    private void manageOptions(String key, Hashtable options, ServletContext application) {
        Object obj = this.optionsTable_.remove(key);
        if (obj != null && obj instanceof String) {
            this.loadOptions((String)obj, options, application);
        } else {
            this.optionsTable_.put(key, options);
        }
    }

    private void loadOptions(String sessionId, Hashtable options, ServletContext application) {
        HttpSession httpSession = (HttpSession)application.getAttribute(sessionId);
        if (httpSession != null) {
            Controller controller = (Controller)httpSession.getAttribute("controller");
            String[] stateLocations = (String[])options.get("stateLocation");
            String[] defaultFavoritesLocations = (String[])options.get("defaultFavoritesLocation");
            String[] inquiryURLs = (String[])options.get("inquiry");
            String[] publishURLs = (String[])options.get("publish");
            String[] serviceNames = (String[])options.get("serviceName");
            String[] serviceKeys = (String[])options.get("serviceKey");
            String[] wsdlURLs = (String[])options.get("wsdl");
            String[] endpoints = (String[])options.get("webServiceEndpoint");
            String[] serviceQNameStrings = (String[])options.get("serviceQNameString");
            String[] bindingNameStrings = (String[])options.get("bindingNameString");
            String stateLocation = stateLocations == null || stateLocations.length == 0 ? null : stateLocations[0];
            controller.setStateLocation(stateLocation);
            String defaultFavoritesLocation = defaultFavoritesLocations == null || defaultFavoritesLocations.length == 0 ? null : defaultFavoritesLocations[0];
            controller.setDefaultFavoritesLocation(defaultFavoritesLocation);
            UDDIPerspective uddiPerspective = controller.getUDDIPerspective();
            uddiPerspective.preloadUDDIRegistries(inquiryURLs, publishURLs);
            uddiPerspective.preloadServices(inquiryURLs, serviceNames, serviceKeys);
            WSDLPerspective wsdlPerspective = controller.getWSDLPerspective();
            wsdlPerspective.preloadWSDL(wsdlURLs);
            wsdlPerspective.preloadEndpoints(wsdlURLs, endpoints);
            wsdlPerspective.preselectServiceOrBinding(wsdlURLs, serviceQNameStrings, bindingNameStrings);
        }
    }
}

