/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFile;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public abstract class ProjectModule
extends ModuleDelegate {
    private IProject project;

    public ProjectModule() {
    }

    public ProjectModule(IProject project) {
        this.project = project;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getId() {
        return this.getProject().getName();
    }

    public IStatus validate() {
        return null;
    }

    public String getName() {
        return this.getProject().getName();
    }

    public boolean exists() {
        return this.getProject() != null && this.getProject().exists();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ProjectModule)) {
            return false;
        }
        ProjectModule dp = (ProjectModule)obj;
        if (this.project != null && this.project.exists() && !this.project.equals((Object)dp.getProject())) {
            return false;
        }
        return this.getId() == null || this.getId().equals(dp.getId());
    }

    public IModule[] getChildModules() {
        return null;
    }

    public boolean isSingleRootStructure() {
        return false;
    }

    public IModuleResource[] members() throws CoreException {
        return this.getModuleResources((IPath)Path.EMPTY, (IContainer)this.getProject());
    }

    protected IModuleResource[] getModuleResources(IPath path, IContainer container) throws CoreException {
        IResource[] resources = container.members();
        if (resources != null) {
            int size = resources.length;
            ArrayList<IModuleResource> list = new ArrayList<IModuleResource>(size);
            int i = 0;
            while (i < size) {
                IFile file;
                IResource resource = resources[i];
                if (resource instanceof IContainer) {
                    IContainer container2 = (IContainer)resource;
                    if (container2 != null && container2.exists()) {
                        ModuleFolder mf = new ModuleFolder(container2, container2.getName(), path);
                        mf.setMembers(this.getModuleResources(path.append(container2.getName()), container2));
                        list.add(mf);
                    }
                } else if (resource instanceof IFile && (file = (IFile)resource) != null && file.exists()) {
                    list.add(new ModuleFile(file, file.getName(), path));
                }
                ++i;
            }
            IModuleResource[] moduleResources = new IModuleResource[list.size()];
            list.toArray(moduleResources);
            return moduleResources;
        }
        return new IModuleResource[0];
    }
}

