/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.editor.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.uml2.uml.editor.UMLEditorPlugin;
import org.eclipse.uml2.uml.editor.actions.UMLCommandAction;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DiagnosticAction
extends UMLCommandAction {
    protected ValidateAction.EclipseResourcesUtil eclipseResourcesUtil = Platform.getBundle((String)"org.eclipse.core.resources") != null ? new ValidateAction.EclipseResourcesUtil(){

        protected String getMarkerID() {
            return DiagnosticAction.this.getMarkerID();
        }
    } : null;
    protected final EValidator.SubstitutionLabelProvider substitutionLabelProvider = new EValidator.SubstitutionLabelProvider(){

        public String getObjectLabel(EObject eObject) {
            return DiagnosticAction.this.getLabelProvider().getText((Object)eObject);
        }

        public String getFeatureLabel(EStructuralFeature eStructuralFeature) {
            return DiagnosticAction.this.getLabelProvider().getText((Object)eStructuralFeature);
        }

        public String getValueLabel(EDataType eDataType, Object value) {
            return EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
        }
    };
    protected final UMLUtil.QualifiedTextProvider qualifiedTextProvider = new UMLUtil.QualifiedTextProvider(){

        public String getFeatureText(EStructuralFeature eStructuralFeature) {
            return DiagnosticAction.this.getLabelProvider().getText((Object)eStructuralFeature);
        }

        public String getClassText(EObject eObject) {
            return DiagnosticAction.this.getLabelProvider().getText((Object)eObject.eClass());
        }
    };

    protected DiagnosticAction() {
    }

    protected String getMarkerID() {
        return "org.eclipse.uml2.uml.editor.diagnostic";
    }

    protected void handleDiagnostic(Diagnostic diagnostic, String dialogTitle) {
        switch (diagnostic.getSeverity()) {
            case 0: {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)dialogTitle, (String)UMLEditorPlugin.INSTANCE.getString("_UI_DiagnosticOK_message"));
                break;
            }
            case 1: {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)dialogTitle, (String)UMLEditorPlugin.INSTANCE.getString("_UI_DiagnosticOK_message"), (IStatus)BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
                break;
            }
            default: {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)dialogTitle, (String)UMLEditorPlugin.INSTANCE.getString("_UI_DiagnosticProblems_message"), (IStatus)BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
            }
        }
        if (this.eclipseResourcesUtil != null) {
            List diagnostics;
            Resource resource;
            HashMap resourceToDiagnosticMap = new HashMap();
            Iterator children = diagnostic.getChildren().iterator();
            while (children.hasNext()) {
                Diagnostic child = (Diagnostic)children.next();
                resource = this.getResource(child);
                if (resource == null) continue;
                diagnostics = (List)resourceToDiagnosticMap.get(resource);
                if (diagnostics == null) {
                    this.eclipseResourcesUtil.deleteMarkers((Object)resource);
                    diagnostics = new ArrayList();
                    resourceToDiagnosticMap.put(resource, diagnostics);
                }
                diagnostics.add(child);
            }
            if (diagnostic.getSeverity() > 1) {
                Object datum;
                List data;
                Iterator entries = resourceToDiagnosticMap.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = entries.next();
                    resource = (Resource)entry.getKey();
                    diagnostics = ((List)entry.getValue()).iterator();
                    while (diagnostics.hasNext()) {
                        this.eclipseResourcesUtil.createMarkers(resource, (Diagnostic)diagnostics.next());
                    }
                }
                if (!diagnostic.getChildren().isEmpty() && !(data = ((Diagnostic)diagnostic.getChildren().get(0)).getData()).isEmpty() && (datum = data.get(0)) instanceof EObject) {
                    Viewer viewer;
                    if (this.workbenchPart instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)this.workbenchPart).selectReveal((ISelection)new StructuredSelection(datum));
                    } else if (this.workbenchPart instanceof IViewerProvider && (viewer = ((IViewerProvider)this.workbenchPart).getViewer()) != null) {
                        viewer.setSelection((ISelection)new StructuredSelection(datum), true);
                    }
                }
            }
        }
    }

    protected Resource getResource(Diagnostic diagnostic) {
        Object datum;
        List data = diagnostic.getData();
        if (!data.isEmpty() && (datum = data.get(0)) instanceof EObject) {
            return ((EObject)datum).eResource();
        }
        return (Resource)this.editingDomain.getResourceSet().getResources().get(0);
    }
}

