/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyModel;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceReference;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;

public class StandardRubyElementContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers;
    protected boolean fProvideWorkingCopy;

    public StandardRubyElementContentProvider() {
        this(false);
    }

    public StandardRubyElementContentProvider(boolean bl, boolean bl2) {
        this(bl);
    }

    public StandardRubyElementContentProvider(boolean bl) {
        this.fProvideMembers = bl;
        this.fProvideWorkingCopy = bl;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean bl) {
        this.fProvideMembers = bl;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public void setProvideWorkingCopy(boolean bl) {
        this.fProvideWorkingCopy = bl;
    }

    public boolean providesWorkingCopies() {
        return this.getProvideWorkingCopy();
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object object) {
        if (!this.exists(object)) {
            return NO_CHILDREN;
        }
        try {
            if (object instanceof IRubyModel) {
                return this.getRubyProjects((IRubyModel)object);
            }
            if (object instanceof IRubyProject) {
                return this.getRubyScripts((IRubyProject)object);
            }
            if (object instanceof IFolder) {
                return this.getResources((IFolder)object);
            }
            if (this.getProvideMembers() && object instanceof ISourceReference && object instanceof IParent) {
                return ((IParent)object).getChildren();
            }
        }
        catch (RubyModelException rubyModelException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    private Object[] getRubyScripts(IRubyProject iRubyProject) throws RubyModelException {
        return iRubyProject.getRubyScripts();
    }

    public boolean hasChildren(Object object) {
        Object[] objectArray;
        if (this.getProvideMembers()) {
            if (object instanceof IRubyScript) {
                return true;
            }
        } else if (object instanceof IRubyScript || object instanceof IFile) {
            return false;
        }
        if (object instanceof IRubyProject && !(objectArray = (Object[])object).getProject().isOpen()) {
            return false;
        }
        if (object instanceof IParent) {
            try {
                if (((IParent)object).hasChildren()) {
                    return true;
                }
            }
            catch (RubyModelException rubyModelException) {
                return true;
            }
        }
        return (objectArray = this.getChildren(object)) != null && objectArray.length > 0;
    }

    public Object getParent(Object object) {
        if (!this.exists(object)) {
            return null;
        }
        return this.internalGetParent(object);
    }

    protected Object[] getRubyProjects(IRubyModel iRubyModel) throws RubyModelException {
        return iRubyModel.getRubyProjects();
    }

    private Object[] getResources(IFolder iFolder) {
        try {
            Object[] objectArray = iFolder.members();
            IRubyProject iRubyProject = RubyCore.create((IProject)iFolder.getProject());
            if (iRubyProject == null || !iRubyProject.exists()) {
                return objectArray;
            }
            boolean bl = true;
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < objectArray.length) {
                Object cfr_ignored_0 = objectArray[n];
                ++n;
            }
            return arrayList.toArray();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    protected boolean isClassPathChange(IRubyElementDelta iRubyElementDelta) {
        return false;
    }

    protected boolean exists(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IResource) {
            return ((IResource)object).exists();
        }
        if (object instanceof IRubyElement) {
            return ((IRubyElement)object).exists();
        }
        return true;
    }

    protected Object internalGetParent(Object object) {
        if (object instanceof IResource) {
            IContainer iContainer = ((IResource)object).getParent();
            IRubyElement iRubyElement = RubyCore.create((IResource)iContainer);
            if (iRubyElement != null && iRubyElement.exists()) {
                return iRubyElement;
            }
            return iContainer;
        }
        if (object instanceof IRubyElement) {
            IRubyElement iRubyElement = ((IRubyElement)object).getParent();
            return iRubyElement;
        }
        return null;
    }

    protected static Object[] concatenate(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        int n2 = objectArray2.length;
        Object[] objectArray3 = new Object[n + n2];
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        System.arraycopy(objectArray2, 0, objectArray3, n, n2);
        return objectArray3;
    }
}

