/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.db;

import gnu.regexp.REMatch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.epic.debug.db.IPPosition;
import org.epic.debug.db.RE;

public class DebuggerInterface {
    private final Object LOCK = new Object();
    private final RE re = new RE();
    private final char[] buf = new char[1024];
    private final BufferedReader in;
    private final PrintWriter out;
    private final IListener listener;
    private final Thread thread;
    private final String perlVersion;
    private boolean disposed;
    private Command asyncCommand;
    public static final int CMD_NONE = 0;
    public static final int CMD_STEP_INTO = 1;
    public static final int CMD_STEP_OVER = 2;
    public static final int CMD_STEP_RETURN = 4;
    public static final int CMD_RESUME = 8;
    public static final int CMD_SUSPEND = 16;
    public static final int CMD_TERMINATE = 32;
    public static final int CMD_CLEAR_OUTPUT = 64;
    public static final int CMD_EXEC = 128;
    public static final int CMD_EVAL = 256;
    public static final int CMD_MODIFIER_RANGE_START = 1024;
    public static final int CMD_MODIFIER_SKIP_EVAL_CMD_RESULT = 1024;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.debug.db.DebuggerInterface");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DebuggerInterface(BufferedReader in, PrintWriter out, IListener listener) throws IOException {
        this.in = in;
        this.out = out;
        this.listener = listener;
        this.thread = new Thread(new Runnable(){

            public void run() {
                DebuggerInterface.this.commandLoop();
            }
        }, "EPIC:DebuggerInterface");
        this.thread.start();
        this.runSyncCommand(64, null);
        this.perlVersion = this.getPerlVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (!this.disposed) {
            try {
                this.runSyncCommand(128, "q");
            }
            catch (IOException iOException) {}
            Object object = this.LOCK;
            synchronized (object) {
                this.disposed = true;
                this.thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commandLoop() {
        Object object = this.LOCK;
        synchronized (object) {
            block5: while (!this.disposed) {
                while (true) {
                    if (this.disposed || this.asyncCommand != null) {
                        if (!this.disposed) break;
                        break block5;
                    }
                    try {
                        this.LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.asyncCommand.run();
                this.LOCK.notifyAll();
            }
            return;
        }
    }

    public Command asyncEval(String code) {
        return this.runAsyncCommand(128, code, true);
    }

    public String eval(String code) throws IOException {
        return this.runSyncCommand(128, code);
    }

    public boolean fileExists(IPath path) throws IOException {
        String osPath = this.getOSPath(path).replaceAll("\\\\", "\\\\\\\\");
        return "1".equals(this.eval("print $DB::OUT -f '" + osPath + "'"));
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isSuspended() {
        return this.asyncCommand == null;
    }

    public IPPosition getCurrentIP() throws IOException {
        String output = this.runSyncCommand(128, ".");
        REMatch result = this.re.IP_POS_CODE.getMatch((Object)output);
        if (result == null) {
            result = this.re.IP_POS.getMatch((Object)output);
            if (result == null) {
                return null;
            }
            String filename = result.toString(1);
            REMatch temp = this.re.IP_POS_EVAL.getMatch((Object)filename);
            if (temp != null) {
                result = temp;
            }
        }
        return new IPPosition((IPath)new Path(result.toString(1)), Integer.parseInt(result.toString(2)));
    }

    public String getOS() throws IOException {
        return this.runSyncCommand(128, "print $DB::OUT $^O;").trim();
    }

    public String getPerlVersion() throws IOException {
        return this.runSyncCommand(128, "printf $DB::OUT \"%vd\", $^V;").trim();
    }

    public String getStackTrace() throws IOException {
        return this.runSyncCommand(128, "T");
    }

    public void redirectError(String host, int port) throws IOException {
        String command = "require IO::Socket; {my $OUT;$OUT = new IO::Socket::INET(Timeout  => '10',PeerAddr => '" + host + ":" + port + "'," + "Proto    => 'tcp',);" + "STDERR->fdopen($OUT,\"w\");}";
        this.runSyncCommand(128, command);
    }

    public void redirectIO(String host, int port) throws IOException {
        String command = "require IO::Socket; {my $OUT;$OUT = new IO::Socket::INET(Timeout  => '10',PeerAddr => '" + host + ":" + port + "'," + "Proto    => 'tcp',);" + "STDOUT->fdopen($OUT,\"w\");" + "STDIN->fdopen($OUT,\"r\");}";
        this.runSyncCommand(128, command);
    }

    public Command asyncResume() {
        return this.runAsyncCommand(8, null, true);
    }

    public void resume() throws IOException {
        this.runSyncCommand(8, null);
    }

    public void setFrame(int count) throws IOException {
        String cmd = this.perlVersion.startsWith("5.6") ? "O frame=" + count : "o frame=" + count;
        this.runSyncCommand(128, cmd);
    }

    public void removeLineBreakpoint(int line) throws IOException {
        String command = this.perlVersion.startsWith("5.6") ? "d " + line : "B " + line;
        this.runSyncCommand(128, command);
    }

    public boolean setLineBreakpoint(int line, String condition) throws IOException {
        String output = this.runSyncCommand(128, "b " + line + (condition != null ? " " + condition : ""));
        return this.re.SET_LINE_BREAKPOINT.getAllMatches((Object)output).length == 0;
    }

    public void setLoadBreakpoint(IPath path) throws IOException {
        this.runSyncCommand(128, "b load " + this.getOSPath(path));
    }

    public Command asyncStepInto() {
        return this.runAsyncCommand(1, null, true);
    }

    public void stepInto() throws IOException {
        this.runSyncCommand(1, null);
    }

    public Command asyncStepOver() {
        return this.runAsyncCommand(2, null, true);
    }

    public void stepOver() throws IOException {
        this.runSyncCommand(2, null);
    }

    public Command asyncStepReturn() {
        return this.runAsyncCommand(4, null, true);
    }

    public void stepReturn() throws IOException {
        this.runSyncCommand(4, null);
    }

    public boolean switchToFile(IPath path) throws IOException {
        String output = this.runSyncCommand(128, "f " + this.getOSPath(path));
        return this.re.SWITCH_FILE_FAIL.getAllMatches((Object)output).length == 0;
    }

    private String getOSPath(IPath path) throws IOException {
        return path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Command runAsyncCommand(int command, String code, boolean notifyOnFinish) {
        Object object = this.LOCK;
        synchronized (object) {
            this.asyncCommand = new Command(command, code, notifyOnFinish);
            this.LOCK.notifyAll();
            return this.asyncCommand;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runSyncCommand(int command, String code) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            Command cmd = this.runAsyncCommand(command, code, false);
            while (this.asyncCommand != null && !this.disposed) {
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return cmd.getResult();
        }
    }

    private String runCommand(int command, String code) throws IOException {
        if (!$assertionsDisabled && Thread.currentThread() != this.thread) {
            throw new AssertionError();
        }
        command = this.maskCommandModifiers(command);
        switch (command) {
            case 1: {
                this.outputLine("s");
                break;
            }
            case 2: {
                this.outputLine("n");
                break;
            }
            case 4: {
                this.outputLine("r");
                break;
            }
            case 8: {
                this.outputLine("c");
                break;
            }
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            case 128: 
            case 256: {
                this.outputLine(code);
                break;
            }
            default: {
                throw new RuntimeException("unrecognized command " + command);
            }
        }
        return this.readCommandOutput();
    }

    private int maskCommandModifiers(int command) {
        return command & 0x3FF;
    }

    private boolean hasCommandTerminated(String fOutput) {
        boolean erg = this.re.CMD_FINISHED1.isMatch((Object)fOutput);
        int count = this.re.CMD_FINISHED1.getAllMatches((Object)fOutput).length;
        if (erg || count > 0) {
            return true;
        }
        erg = this.re.CMD_FINISHED2.isMatch((Object)fOutput);
        count = this.re.CMD_FINISHED2.getAllMatches((Object)fOutput).length;
        return erg || count > 0;
    }

    private boolean hasSessionTerminated(String fOutput) {
        boolean erg = this.re.SESSION_FINISHED1.isMatch((Object)fOutput);
        int count = this.re.SESSION_FINISHED1.getAllMatches((Object)fOutput).length;
        if (erg || count > 0) {
            return true;
        }
        erg = this.re.SESSION_FINISHED2.isMatch((Object)fOutput);
        count = this.re.SESSION_FINISHED2.getAllMatches((Object)fOutput).length;
        return erg || count > 0;
    }

    private void outputLine(String line) {
        this.out.println(line);
    }

    private String readCommandOutput() throws IOException {
        int nlIndex;
        StringBuffer output = new StringBuffer();
        while (true) {
            int count;
            try {
                count = this.in.read(this.buf);
                if (count > 0) {
                    output.append(this.buf, 0, count);
                }
                try {
                    if (this.in.ready()) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                }
            }
            catch (IOException e) {
                this.fireSessionTerminated();
                throw e;
            }
            int inspectLen = Math.min(output.length(), 350);
            String currentOutput = output.substring(output.length() - inspectLen, output.length());
            if (count < 0 || this.hasSessionTerminated(currentOutput)) {
                this.fireSessionTerminated();
                return null;
            }
            if (this.hasCommandTerminated(currentOutput)) break;
        }
        int lfIndex = output.lastIndexOf("\n");
        int crIndex = output.lastIndexOf("\r");
        if (lfIndex < 0) {
            lfIndex = Integer.MAX_VALUE;
        }
        if (crIndex < 0) {
            crIndex = Integer.MAX_VALUE;
        }
        if ((nlIndex = Math.min(crIndex, lfIndex)) != Integer.MAX_VALUE) {
            return output.substring(0, nlIndex);
        }
        return output.toString();
    }

    private void fireSessionTerminated() {
        if (!this.disposed && this.listener != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    DebuggerInterface.this.listener.sessionTerminated();
                }
            });
        }
    }

    public static interface IListener {
        public void commandFinished(Command var1);

        public void sessionTerminated();
    }

    public class Command {
        private final int type;
        private final String code;
        private final boolean notifyOnFinish;
        private String result;
        private IOException error;

        public Command(int type, String code, boolean notifyOnFinish) {
            this.type = type;
            this.code = code;
            this.notifyOnFinish = notifyOnFinish;
        }

        public String getResult() throws IOException {
            if (this.error != null) {
                throw this.error;
            }
            return this.result;
        }

        public String getCode() {
            return this.code;
        }

        public boolean isStepCommand() {
            return this.type == 1 || this.type == 2 || this.type == 4;
        }

        public int getType() {
            return this.type;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void run() {
            try {
                try {
                    this.result = DebuggerInterface.this.runCommand(this.type, this.code);
                }
                catch (IOException e) {
                    this.error = e;
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                DebuggerInterface.this.asyncCommand = null;
                if (!this.notifyOnFinish) throw throwable;
                if (DebuggerInterface.this.listener == null) throw throwable;
                Display.getDefault().asyncExec(new Runnable(this){
                    final /* synthetic */ Command this$1;
                    {
                        this.this$1 = command;
                    }

                    public void run() {
                        DebuggerInterface.access$1(Command.access$0(this.this$1)).commandFinished(this.this$1);
                    }
                });
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            DebuggerInterface.this.asyncCommand = null;
            if (!this.notifyOnFinish) return;
            if (DebuggerInterface.this.listener == null) return;
            Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
        }

        public String toString() {
            return "Command #" + this.type + " {" + this.code + "}" + ", notify=" + this.notifyOnFinish;
        }

        static /* synthetic */ DebuggerInterface access$0(Command command) {
            return command.DebuggerInterface.this;
        }
    }
}

