/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.amqp.AmqpNioTransport;
import org.apache.activemq.transport.amqp.AmqpTransportFilter;
import org.apache.activemq.transport.nio.NIOTransportFactory;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.transport.tcp.TcpTransportServer;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class AmqpNioTransportFactory
extends NIOTransportFactory
implements BrokerServiceAware {
    private BrokerContext brokerContext = null;

    @Override
    protected String getDefaultWireFormatType() {
        return "amqp";
    }

    @Override
    protected TcpTransportServer createTcpTransportServer(URI location, ServerSocketFactory serverSocketFactory) throws IOException, URISyntaxException {
        return new TcpTransportServer(this, location, serverSocketFactory){

            @Override
            protected Transport createTransport(Socket socket, WireFormat format2) throws IOException {
                return new AmqpNioTransport(format2, socket);
            }
        };
    }

    @Override
    protected TcpTransport createTcpTransport(WireFormat wf, SocketFactory socketFactory, URI location, URI localLocation) throws UnknownHostException, IOException {
        return new AmqpNioTransport(wf, socketFactory, location, localLocation);
    }

    @Override
    public Transport serverConfigure(Transport transport, WireFormat format2, HashMap options) throws Exception {
        if ((transport = super.serverConfigure(transport, format2, options)) instanceof MutexTransport) {
            transport = ((MutexTransport)transport).getNext();
        }
        return transport;
    }

    @Override
    public Transport compositeConfigure(Transport transport, WireFormat format2, Map options) {
        transport = new AmqpTransportFilter(transport, format2, this.brokerContext);
        IntrospectionSupport.setProperties(transport, options);
        return super.compositeConfigure(transport, format2, options);
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerContext = brokerService.getBrokerContext();
    }

    @Override
    protected boolean isUseInactivityMonitor(Transport transport) {
        return false;
    }
}

