/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

@XmlType(name="loadBalancer")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LoadBalancerDefinition
extends IdentifiedType
implements LoadBalancer {
    @XmlTransient
    private LoadBalancer loadBalancer;
    @XmlTransient
    private String loadBalancerTypeName;

    public LoadBalancerDefinition() {
    }

    public LoadBalancerDefinition(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    protected LoadBalancerDefinition(String loadBalancerTypeName) {
        this.loadBalancerTypeName = loadBalancerTypeName;
    }

    public static LoadBalancer getLoadBalancer(RouteContext routeContext, LoadBalancerDefinition type, String ref) {
        if (type == null) {
            ObjectHelper.notNull(ref, "ref or loadBalancer");
            LoadBalancer loadBalancer = routeContext.mandatoryLookup(ref, LoadBalancer.class);
            if (loadBalancer instanceof LoadBalancerDefinition) {
                type = (LoadBalancerDefinition)loadBalancer;
            } else {
                return loadBalancer;
            }
        }
        return type.getLoadBalancer(routeContext);
    }

    protected void setProperty(Object bean, String name, Object value) {
        try {
            IntrospectionSupport.setProperty(bean, name, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to set property " + name + " on " + bean + ". Reason: " + e, e);
        }
    }

    protected void configureLoadBalancer(LoadBalancer loadBalancer) {
    }

    public LoadBalancer getLoadBalancer(RouteContext routeContext) {
        if (this.loadBalancer == null) {
            this.loadBalancer = this.createLoadBalancer(routeContext);
            ObjectHelper.notNull(this.loadBalancer, "loadBalancer");
            this.configureLoadBalancer(this.loadBalancer);
        }
        return this.loadBalancer;
    }

    protected LoadBalancer createLoadBalancer(RouteContext routeContext) {
        if (this.loadBalancerTypeName != null) {
            Class<?> type = routeContext.getCamelContext().getClassResolver().resolveClass(this.loadBalancerTypeName);
            if (type == null) {
                throw new IllegalArgumentException("Cannot find class: " + this.loadBalancerTypeName + " in the classpath");
            }
            return (LoadBalancer)ObjectHelper.newInstance(type);
        }
        return null;
    }

    @Override
    public void addProcessor(Processor processor) {
        ObjectHelper.notNull(this.loadBalancer, "loadBalancer", this);
        this.loadBalancer.addProcessor(processor);
    }

    @Override
    public List<Processor> getProcessors() {
        ObjectHelper.notNull(this.loadBalancer, "loadBalancer", this);
        return this.loadBalancer.getProcessors();
    }

    @Override
    public void removeProcessor(Processor processor) {
        ObjectHelper.notNull(this.loadBalancer, "loadBalancer", this);
        this.loadBalancer.removeProcessor(processor);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        ObjectHelper.notNull(this.loadBalancer, "loadBalancer", this);
        this.loadBalancer.process(exchange);
    }

    @Override
    public boolean process(Exchange exchange, final AsyncCallback callback) {
        ObjectHelper.notNull(this.loadBalancer, "loadBalancer");
        return this.loadBalancer.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (doneSync) {
                    return;
                }
                callback.done(false);
            }
        });
    }

    public String toString() {
        if (this.loadBalancer != null) {
            return this.loadBalancer.toString();
        }
        return this.loadBalancerTypeName;
    }
}

