/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaskRequiredModelMBean
extends RequiredModelMBean {
    private static final Logger LOG = LoggerFactory.getLogger(MaskRequiredModelMBean.class);
    private boolean mask;

    public MaskRequiredModelMBean() throws MBeanException, RuntimeOperationsException {
    }

    public MaskRequiredModelMBean(ModelMBeanInfo mbi, boolean mask) throws MBeanException, RuntimeOperationsException {
        super(mbi);
        this.mask = mask;
    }

    public boolean isMask() {
        return this.mask;
    }

    @Override
    public Object invoke(String opName, Object[] opArgs, String[] sig) throws MBeanException, ReflectionException {
        Object answer = super.invoke(opName, opArgs, sig);
        if (this.mask && answer instanceof String && ObjectHelper.isNotEmpty(answer) && this.isMaskOperation(opName)) {
            answer = this.mask(opName, (String)answer);
        }
        return answer;
    }

    protected boolean isMaskOperation(String opName) {
        for (MBeanOperationInfo info : this.getMBeanInfo().getOperations()) {
            Descriptor desc;
            if (!info.getName().equals(opName) || (desc = info.getDescriptor()) == null) continue;
            Object val = desc.getFieldValue("mask");
            return val != null && "true".equals(val);
        }
        return false;
    }

    protected String mask(String opName, String value) {
        String answer = URISupport.sanitizeUri(value);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Masking JMX operation: {}.{} value: {} -> {}", new Object[]{this.getMBeanInfo().getClassName(), opName, value, answer});
        }
        return answer;
    }
}

