/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanEndpoint;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanInfoCacheKey;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.LRUSoftCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(BeanComponent.class);
    private final LRUSoftCache<BeanInfoCacheKey, BeanInfo> cache = new LRUSoftCache(1000);

    public BeanComponent() {
        super(BeanEndpoint.class);
    }

    public ProcessorEndpoint createEndpoint(Object bean) {
        String uri = "bean:generated:" + bean;
        return this.createEndpoint(bean, uri);
    }

    public ProcessorEndpoint createEndpoint(Object bean, String uri) {
        BeanProcessor processor = new BeanProcessor(bean, this.getCamelContext());
        return this.createEndpoint(uri, processor);
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BeanEndpoint endpoint = new BeanEndpoint(uri, this);
        endpoint.setBeanName(remaining);
        Boolean cache = this.getAndRemoveParameter(parameters, "cache", Boolean.class, Boolean.FALSE);
        endpoint.setCache(cache);
        Processor processor = endpoint.getProcessor();
        this.setProperties(processor, parameters);
        return endpoint;
    }

    protected BeanEndpoint createEndpoint(String uri, BeanProcessor processor) {
        return new BeanEndpoint(uri, (Component)this, processor);
    }

    BeanInfo getBeanInfoFromCache(BeanInfoCacheKey key) {
        return this.cache.get(key);
    }

    void addBeanInfoToCache(BeanInfoCacheKey key, BeanInfo beanInfo) {
        this.cache.put(key, beanInfo);
    }

    @Override
    protected void doShutdown() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing BeanInfo cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{this.cache.size(), this.cache.getHits(), this.cache.getMisses(), this.cache.getEvicted()});
        }
        this.cache.clear();
    }
}

